/// <reference path="./internal_*.d.ts" />
declare namespace com.mojang.blaze3d.platform {
    class Window implements Internal.WindowKJS, Internal.NativeWindowHandle, Internal.AutoCloseable, Internal.WindowHooks {
        constructor($$0: Internal.WindowEventHandler_, $$1: any_, $$2: Internal.DisplayData_, $$3: string, $$4: string)
        setFramerateLimit($$0: number): void;
        getX(): number;
        getY(): number;
        getPreferredFullscreenVideoMode(): Internal.Optional<Internal.VideoMode>;
        calculateScale($$0: number, $$1: boolean): number;
        findBestMonitor(): Internal.Monitor;
        setErrorSection($$0: string): void;
        isFullscreen(): boolean;
        setGuiScale($$0: number): void;
        kjs$loadIcons(original: Internal.List_<Internal.IoSupplier<Internal.InputStream>>): Internal.List<Internal.IoSupplier<Internal.InputStream>>;
        redirect$bgc000$borderlessmining$constructorIsFullscreen(window: com.mojang.blaze3d.platform.Window_): boolean;
        borderlessmining_apply(): void;
        setPreferredFullscreenVideoMode($$0: Internal.Optional_<Internal.VideoMode>): void;
        shouldClose(): boolean;
        setWidth($$0: number): void;
        changeFullscreenVideoMode(): void;
        getHeight(): number;
        defaultErrorCallback($$0: number, $$1: number): void;
        updateRawMouseInput($$0: boolean): void;
        getGuiScaledWidth(): number;
        setDefaultErrorCallback(): void;
        static checkGlfwError($$0: Internal.BiConsumer_<number, string>): void;
        getFramerateLimit(): number;
        getScreenHeight(): number;
        setIcon($$0: Internal.PackResources_, $$1: Internal.IconSet_): void;
        getWidth(): number;
        updateVsync($$0: boolean): void;
        getWindow(): number;
        getGuiScaledHeight(): number;
        handler$bgc000$borderlessmining$onToggleFullscreen(info: Internal.CallbackInfo_): void;
        getWin32Handle(): number;
        setWindowed($$0: number, $$1: number): void;
        setTitle($$0: string): void;
        getScreenWidth(): number;
        getGuiScale(): number;
        handler$hdh000$sodium$setAdditionalWindowHints(ci: Internal.CallbackInfo_): void;
        close(): void;
        toggleFullScreen(): void;
        setHeight($$0: number): void;
        updateDisplay(): void;
        getRefreshRate(): number;
        set framerateLimit($$0: number)
        get x(): number
        get y(): number
        get preferredFullscreenVideoMode(): Internal.Optional<Internal.VideoMode>
        set errorSection($$0: string)
        get fullscreen(): boolean
        set guiScale($$0: number)
        set preferredFullscreenVideoMode($$0: Internal.Optional_<Internal.VideoMode>)
        set width($$0: number)
        get height(): number
        get guiScaledWidth(): number
        get framerateLimit(): number
        get screenHeight(): number
        get width(): number
        get window(): number
        get guiScaledHeight(): number
        get win32Handle(): number
        set title($$0: string)
        get screenWidth(): number
        get guiScale(): number
        set height($$0: number)
        get refreshRate(): number
    }
    type Window_ = Window;
}
declare namespace Internal {
    class IPartitionList$Builder {
        add(key: Internal.AEKey_): void;
        fuzzyMode(mode: Internal.FuzzyMode_): void;
        addAll(keys: Internal.Iterable_<Internal.AEKey>): void;
        build(): Internal.IPartitionList;
    }
    type IPartitionList$Builder_ = IPartitionList$Builder;
    class ClientboundBundlePacket extends Internal.BundlePacket<Internal.ClientGamePacketListener> {
        constructor($$0: Internal.Iterable_<Internal.Packet<Internal.ClientGamePacketListener>>)
        handle($$0: Internal.ClientGamePacketListener_): void;
        isSkippable(): boolean;
        get skippable(): boolean
    }
    type ClientboundBundlePacket_ = ClientboundBundlePacket;
    class StructureBlock extends Internal.BaseEntityBlock implements Internal.GameMasterBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>($$0: Internal.Level_, $$1: Internal.BlockState_, $$2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly MODE: Internal.EnumProperty<Internal.StructureMode>;
    }
    type StructureBlock_ = StructureBlock;
    class ChannelBlock$ChannelConnection extends Internal.Enum<Internal.ChannelBlock$ChannelConnection> implements Internal.StringRepresentable {
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        getNext(reverse: boolean): this;
        getSerializedName(): string;
        canFlow(): boolean;
        getOpposite(): this;
        static valueOf(name: string): Internal.ChannelBlock$ChannelConnection;
        static values(): Internal.ChannelBlock$ChannelConnection[];
        get serializedName(): string
        get opposite(): Internal.ChannelBlock$ChannelConnection
        static readonly NONE: Internal.ChannelBlock$ChannelConnection;
        static readonly IN: Internal.ChannelBlock$ChannelConnection;
        static readonly OUT: Internal.ChannelBlock$ChannelConnection;
    }
    type ChannelBlock$ChannelConnection_ = "out" | "in" | ChannelBlock$ChannelConnection | "none";
    class PushDirection extends Internal.Enum<Internal.PushDirection> implements Internal.StringRepresentable {
        static fromDirection(direction: Internal.Direction_): Internal.PushDirection;
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        getSerializedName(): string;
        static valueOf(name: string): Internal.PushDirection;
        static values(): Internal.PushDirection[];
        getDirection(): Internal.Direction;
        get serializedName(): string
        get direction(): Internal.Direction
        static readonly EAST: Internal.PushDirection;
        static readonly WEST: Internal.PushDirection;
        static readonly UP: Internal.PushDirection;
        static readonly SOUTH: Internal.PushDirection;
        static readonly ALL: Internal.PushDirection;
        static readonly NORTH: Internal.PushDirection;
        static readonly DOWN: Internal.PushDirection;
    }
    type PushDirection_ = "west" | PushDirection | "east" | "south" | "up" | "down" | "north" | "all";
    abstract class BookPage {
        constructor()
        build(level: Internal.Level_, entry: Internal.BookEntry_, builder: Internal.BookContentsBuilder_, pageNum: number): void;
        canAdd(book: Internal.Book_): boolean;
        render(graphics: Internal.GuiGraphics_, mouseX: number, mouseY: number, pticks: number): void;
        onDisplayed(parent: Internal.GuiBookEntry_, left: number, top: number): void;
        isPageUnlocked(): boolean;
        mouseClicked(mouseX: number, mouseY: number, mouseButton: number): boolean;
        i18nText(text: string): net.minecraft.network.chat.Component;
        i18n(text: string): string;
        onHidden(parent: Internal.GuiBookEntry_): void;
        get pageUnlocked(): boolean
    }
    type BookPage_ = BookPage;
    class PrimedTnt extends Internal.Entity implements Internal.TraceableEntity, Internal.EntityDynamicLightSource {
        constructor($$0: Internal.EntityType_<Internal.PrimedTnt>, $$1: Internal.Level_)
        constructor($$0: Internal.Level_, $$1: number, $$2: number, $$3: number, $$4: Internal.LivingEntity_)
        setMotionY(y: number): void;
        isPeacefulCreature(): boolean;
        setFuse($$0: number): void;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        getDistance(pos: BlockPos_): number;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        setRotation(yaw: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        isOnScoreboardTeam(teamId: string): boolean;
        getType(): string;
        getOwner(): Internal.LivingEntity;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        self(): Internal.Entity;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        setPosition(x: number, y: number, z: number): void;
        getPassengers(): Internal.EntityArrayList;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        sophisticatedInvalidateCaps(): void;
        lithiumOnBlockCacheSet(newState: Internal.BlockState_): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        isLiving(): boolean;
        static tickEntity(entity: Internal.Entity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        alwaysAccepts(): boolean;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        getOwner(): Internal.Entity;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        getDisplayName(): net.minecraft.network.chat.Component;
        setMotionX(x: number): void;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        attack(hp: number): void;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getTeamId(): string;
        setNbt(nbt: Internal.CompoundTag_): void;
        lithiumSetClimbingMobCachingSectionUpdateBehavior(listening: boolean): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        serializeNBT(): Internal.Tag;
        setDynamicLightEnabled(enabled: boolean): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getMotionX(): number;
        isWaterCreature(): boolean;
        handler$zio004$ad_astra$adastra$tick(ci: Internal.CallbackInfo_): void;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        tell(message: net.minecraft.network.chat.Component_): void;
        getFuse(): number;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        isFrame(): boolean;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        getProfile(): Internal.GameProfile;
        playSound(id: Internal.SoundEvent_): void;
        lithiumOnBlockCacheDeleted(): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        runCommand(command: string): number;
        getDistance(x: number, y: number, z: number): number;
        set motionY(y: number)
        get peacefulCreature(): boolean
        set fuse($$0: number)
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        get owner(): Internal.LivingEntity
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        get owner(): Internal.Entity
        get server(): Internal.MinecraftServer
        get displayName(): net.minecraft.network.chat.Component
        set motionX(x: number)
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get teamId(): string
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        get facing(): Internal.Direction
        set dynamicLightEnabled(enabled: boolean)
        get motionX(): number
        get waterCreature(): boolean
        get motionZ(): number
        get item(): Internal.ItemStack
        set x(x: number)
        get fuse(): number
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get frame(): boolean
        get profile(): Internal.GameProfile
    }
    type PrimedTnt_ = PrimedTnt;
    interface ValueLayout extends Internal.MemoryLayout {
        sequenceLayout(arg0: number, arg1: Internal.MemoryLayout_): Internal.SequenceLayout;
        abstract toString(): string;
        abstract arrayElementVarHandle(...arg0: number[]): Internal.VarHandle;
        withName(arg0: string): Internal.MemoryLayout;
        sequenceLayout(arg0: Internal.MemoryLayout_): Internal.SequenceLayout;
        abstract name(): Internal.Optional<string>;
        byteOffset(...arg0: any_[]): number;
        abstract byteSize(): number;
        withByteAlignment(arg0: number): Internal.MemoryLayout;
        abstract withOrder(arg0: Internal.ByteOrder_): this;
        structLayout(...arg0: Internal.MemoryLayout_[]): Internal.StructLayout;
        withoutName(): Internal.MemoryLayout;
        abstract hashCode(): number;
        abstract order(): Internal.ByteOrder;
        select(...arg0: any_[]): Internal.MemoryLayout;
        sliceHandle(...arg0: any_[]): Internal.MethodHandle;
        paddingLayout(arg0: number): Internal.PaddingLayout;
        varHandle(...arg0: any_[]): Internal.VarHandle;
        abstract byteAlignment(): number;
        byteOffsetHandle(...arg0: any_[]): Internal.MethodHandle;
        abstract carrier(): typeof any;
        unionLayout(...arg0: Internal.MemoryLayout_[]): Internal.UnionLayout;
        abstract equals(arg0: any): boolean;
        readonly JAVA_LONG: Internal.ValueLayouts$OfLongImpl;
        readonly ADDRESS: Internal.ValueLayouts$OfAddressImpl;
        readonly JAVA_SHORT_UNALIGNED: Internal.ValueLayouts$OfShortImpl;
        readonly JAVA_FLOAT: Internal.ValueLayouts$OfFloatImpl;
        readonly JAVA_CHAR_UNALIGNED: Internal.ValueLayouts$OfCharImpl;
        readonly JAVA_FLOAT_UNALIGNED: Internal.ValueLayouts$OfFloatImpl;
        readonly JAVA_INT_UNALIGNED: Internal.ValueLayouts$OfIntImpl;
        readonly JAVA_INT: Internal.ValueLayouts$OfIntImpl;
        readonly JAVA_BYTE: Internal.ValueLayouts$OfByteImpl;
        readonly JAVA_BOOLEAN: Internal.ValueLayouts$OfBooleanImpl;
        readonly ADDRESS_UNALIGNED: Internal.ValueLayouts$OfAddressImpl;
        readonly JAVA_LONG_UNALIGNED: Internal.ValueLayouts$OfLongImpl;
        readonly JAVA_CHAR: Internal.ValueLayouts$OfCharImpl;
        readonly JAVA_DOUBLE_UNALIGNED: Internal.ValueLayouts$OfDoubleImpl;
        readonly JAVA_SHORT: Internal.ValueLayouts$OfShortImpl;
        readonly JAVA_DOUBLE: Internal.ValueLayouts$OfDoubleImpl;
    }
    type ValueLayout_ = ValueLayout;
    interface IGridNode {
        abstract getMaxChannels(): number;
        abstract getLevel(): Internal.ServerLevel;
        abstract getConnectedSides(): Internal.Set<Internal.Direction>;
        abstract getVisualRepresentation(): Internal.AEItemKey;
        isActive(): boolean;
        isOnline(): boolean;
        abstract getInWorldConnections(): Internal.Map<Internal.Direction, Internal.IGridConnection>;
        abstract hasGridBooted(): boolean;
        abstract getOwningPlayerId(): number;
        abstract meetsChannelRequirements(): boolean;
        abstract getConnections(): Internal.List<Internal.IGridConnection>;
        abstract getGrid(): Internal.IGrid;
        abstract getOwner(): any;
        abstract getService<T extends Internal.IGridNodeService>(arg0: T): T;
        abstract getUsedChannels(): number;
        abstract hasFlag(arg0: Internal.GridFlags_): boolean;
        abstract getGridColor(): Internal.AEColor;
        abstract getOwningPlayerProfileId(): Internal.UUID;
        abstract fillCrashReportCategory(arg0: Internal.CrashReportCategory_): void;
        abstract beginVisit(arg0: Internal.IGridVisitor_): void;
        abstract getIdlePowerUsage(): number;
        abstract isPowered(): boolean;
        get maxChannels(): number
        get level(): Internal.ServerLevel
        get connectedSides(): Internal.Set<Internal.Direction>
        get visualRepresentation(): Internal.AEItemKey
        get active(): boolean
        get online(): boolean
        get inWorldConnections(): Internal.Map<Internal.Direction, Internal.IGridConnection>
        get owningPlayerId(): number
        get connections(): Internal.List<Internal.IGridConnection>
        get grid(): Internal.IGrid
        get owner(): any
        get usedChannels(): number
        get gridColor(): Internal.AEColor
        get owningPlayerProfileId(): Internal.UUID
        get idlePowerUsage(): number
        get powered(): boolean
    }
    type IGridNode_ = IGridNode;
    class TeamArgument$Info$Template implements Internal.ArgumentTypeInfo$Template<Internal.TeamArgument> {
        constructor(this$0: Internal.TeamArgument$Info_)
        instantiate(arg0: Internal.CommandBuildContext_): Internal.ArgumentType<any>;
        instantiate(commandBuildContext: Internal.CommandBuildContext_): Internal.TeamArgument;
        type(): Internal.ArgumentTypeInfo<Internal.TeamArgument, any>;
    }
    type TeamArgument$Info$Template_ = TeamArgument$Info$Template;
    class DropperBlock extends Internal.DispenserBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>($$0: Internal.Level_, $$1: Internal.BlockState_, $$2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        static getDispenserRegistry(): Internal.Map<Internal.Item, Internal.DispenseItemBehavior>;
        emi(): Internal.EmiStack;
        "handler$cmd000$fabric-transfer-api-v1$hookDispense"(world: Internal.ServerLevel_, pos: BlockPos_, ci: Internal.CallbackInfo_): void;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        get dispenserRegistry(): Internal.Map<Internal.Item, Internal.DispenseItemBehavior>
    }
    type DropperBlock_ = DropperBlock;
    interface IotaMultiPredicate {
        either(first: Internal.IotaMultiPredicate_, second: Internal.IotaMultiPredicate_): this;
        triple(first: Internal.IotaPredicate_, second: Internal.IotaPredicate_, third: Internal.IotaPredicate_): this;
        abstract test(arg0: Internal.Iterable_<Internal.Iota>): boolean;
        any(needs: Internal.IotaPredicate_, fallback: Internal.IotaPredicate_): this;
        all(child: Internal.IotaPredicate_): this;
        pair(first: Internal.IotaPredicate_, second: Internal.IotaPredicate_): this;
        (arg0: Internal.Iterable<Internal.Iota>): boolean;
    }
    type IotaMultiPredicate_ = IotaMultiPredicate;
    class Products$P1 <F extends Internal.K1, T1> {
        constructor(arg0: Internal.App_<F, T1>)
        apply<R>(arg0: Internal.Applicative_<F, any>, arg1: Internal.Function_<T1, R>): Internal.App<F, R>;
        t1(): Internal.App<F, T1>;
        and<T2, T3>(arg0: Internal.Products$P2_<F, T2, T3>): Internal.Products$P3<F, T1, T2, T3>;
        and<T2, T3, T4, T5, T6>(arg0: Internal.Products$P5_<F, T2, T3, T4, T5, T6>): Internal.Products$P6<F, T1, T2, T3, T4, T5, T6>;
        and<T2>(arg0: Internal.App_<F, T2>): Internal.Products$P2<F, T1, T2>;
        and<T2, T3, T4, T5, T6, T7, T8>(arg0: Internal.Products$P7_<F, T2, T3, T4, T5, T6, T7, T8>): Internal.Products$P8<F, T1, T2, T3, T4, T5, T6, T7, T8>;
        and<T2, T3, T4>(arg0: Internal.Products$P3_<F, T2, T3, T4>): Internal.Products$P4<F, T1, T2, T3, T4>;
        and<T2, T3, T4, T5, T6, T7>(arg0: Internal.Products$P6_<F, T2, T3, T4, T5, T6, T7>): Internal.Products$P7<F, T1, T2, T3, T4, T5, T6, T7>;
        apply<R>(arg0: Internal.Applicative_<F, any>, arg1: Internal.App_<F, Internal.Function<T1, R>>): Internal.App<F, R>;
        and<T2, T3, T4, T5>(arg0: Internal.Products$P4_<F, T2, T3, T4, T5>): Internal.Products$P5<F, T1, T2, T3, T4, T5>;
    }
    type Products$P1_<F extends Internal.K1, T1> = Products$P1<F, T1>;
    class Products$P3 <F extends Internal.K1, T1, T2, T3> {
        constructor(arg0: Internal.App_<F, T1>, arg1: Internal.App_<F, T2>, arg2: Internal.App_<F, T3>)
        and<T4>(arg0: Internal.App_<F, T4>): Internal.Products$P4<F, T1, T2, T3, T4>;
        t1(): Internal.App<F, T1>;
        t2(): Internal.App<F, T2>;
        and<T4, T5>(arg0: Internal.Products$P2_<F, T4, T5>): Internal.Products$P5<F, T1, T2, T3, T4, T5>;
        and<T4, T5, T6, T7>(arg0: Internal.Products$P4_<F, T4, T5, T6, T7>): Internal.Products$P7<F, T1, T2, T3, T4, T5, T6, T7>;
        t3(): Internal.App<F, T3>;
        and<T4, T5, T6, T7, T8>(arg0: Internal.Products$P5_<F, T4, T5, T6, T7, T8>): Internal.Products$P8<F, T1, T2, T3, T4, T5, T6, T7, T8>;
        apply<R>(arg0: Internal.Applicative_<F, any>, arg1: Internal.Function3_<T1, T2, T3, R>): Internal.App<F, R>;
        and<T4, T5, T6>(arg0: Internal.Products$P3_<F, T4, T5, T6>): Internal.Products$P6<F, T1, T2, T3, T4, T5, T6>;
        apply<R>(arg0: Internal.Applicative_<F, any>, arg1: Internal.App_<F, Internal.Function3<T1, T2, T3, R>>): Internal.App<F, R>;
    }
    type Products$P3_<F extends Internal.K1, T1, T2, T3> = Products$P3<F, T1, T2, T3>;
    class StatType <T> implements Internal.Iterable<Internal.Stat<T>> {
        constructor($$0: Internal.Registry_<T>)
        contains($$0: T): boolean;
        getDisplayName(): net.minecraft.network.chat.Component;
        getRegistry(): Internal.Registry<T>;
        iterator(): Internal.Iterator<Internal.Stat<T>>;
        spliterator(): Internal.Spliterator<Internal.Stat<T>>;
        get($$0: T): Internal.Stat<T>;
        getTranslationKey(): string;
        get($$0: T, $$1: Internal.StatFormatter_): Internal.Stat<T>;
        forEach(arg0: Internal.Consumer_<Internal.Stat<T>>): void;
        get displayName(): net.minecraft.network.chat.Component
        get registry(): Internal.Registry<T>
        get translationKey(): string
    }
    type StatType_<T> = Special.StatType | StatType<T>;
    interface AccessorRenderType {
        hex$create(string: string, vertexFormat: Internal.VertexFormat_, mode: Internal.VertexFormat$Mode_, bufSize: number, hasCrumbling: boolean, sortOnUpload: boolean, compositeState: Internal.RenderType$CompositeState_): Internal.RenderType$CompositeRenderType;
    }
    type AccessorRenderType_ = AccessorRenderType;
    class Input {
        constructor()
        hasForwardImpulse(): boolean;
        getMoveVector(): Internal.Vec2;
        tick($$0: boolean, $$1: number): void;
        get moveVector(): Internal.Vec2
        up: boolean;
        forwardImpulse: number;
        down: boolean;
        shiftKeyDown: boolean;
        right: boolean;
        jumping: boolean;
        left: boolean;
        leftImpulse: number;
    }
    type Input_ = Input;
    class Products$P2 <F extends Internal.K1, T1, T2> {
        constructor(arg0: Internal.App_<F, T1>, arg1: Internal.App_<F, T2>)
        and<T3, T4, T5, T6>(arg0: Internal.Products$P4_<F, T3, T4, T5, T6>): Internal.Products$P6<F, T1, T2, T3, T4, T5, T6>;
        t1(): Internal.App<F, T1>;
        t2(): Internal.App<F, T2>;
        apply<R>(arg0: Internal.Applicative_<F, any>, arg1: Internal.App_<F, Internal.BiFunction<T1, T2, R>>): Internal.App<F, R>;
        and<T3, T4, T5, T6, T7>(arg0: Internal.Products$P5_<F, T3, T4, T5, T6, T7>): Internal.Products$P7<F, T1, T2, T3, T4, T5, T6, T7>;
        and<T3, T4, T5>(arg0: Internal.Products$P3_<F, T3, T4, T5>): Internal.Products$P5<F, T1, T2, T3, T4, T5>;
        apply<R>(arg0: Internal.Applicative_<F, any>, arg1: Internal.BiFunction_<T1, T2, R>): Internal.App<F, R>;
        and<T3, T4>(arg0: Internal.Products$P2_<F, T3, T4>): Internal.Products$P4<F, T1, T2, T3, T4>;
        and<T3, T4, T5, T6, T7, T8>(arg0: Internal.Products$P6_<F, T3, T4, T5, T6, T7, T8>): Internal.Products$P8<F, T1, T2, T3, T4, T5, T6, T7, T8>;
        and<T3>(arg0: Internal.App_<F, T3>): Internal.Products$P3<F, T1, T2, T3>;
    }
    type Products$P2_<F extends Internal.K1, T1, T2> = Products$P2<F, T1, T2>;
    class SuggestionsBuilder {
        constructor(arg0: string, arg1: number)
        constructor(arg0: string, arg1: string, arg2: number)
        getRemainingLowerCase(): string;
        getStart(): number;
        suggest(arg0: string, arg1: Internal.Message_): this;
        buildFuture(): Internal.CompletableFuture<Internal.Suggestions>;
        suggest(arg0: string): this;
        getInput(): string;
        build(): Internal.Suggestions;
        suggest(arg0: number): this;
        restart(): this;
        suggest(arg0: number, arg1: Internal.Message_): this;
        getRemaining(): string;
        add(arg0: Internal.SuggestionsBuilder_): this;
        createOffset(arg0: number): this;
        get remainingLowerCase(): string
        get start(): number
        get input(): string
        get remaining(): string
    }
    type SuggestionsBuilder_ = SuggestionsBuilder;
    class Products$P9 <F extends Internal.K1, T1, T2, T3, T4, T5, T6, T7, T8, T9> {
        constructor(arg0: Internal.App_<F, T1>, arg1: Internal.App_<F, T2>, arg2: Internal.App_<F, T3>, arg3: Internal.App_<F, T4>, arg4: Internal.App_<F, T5>, arg5: Internal.App_<F, T6>, arg6: Internal.App_<F, T7>, arg7: Internal.App_<F, T8>, arg8: Internal.App_<F, T9>)
        apply<R>(arg0: Internal.Applicative_<F, any>, arg1: Internal.Function9_<T1, T2, T3, T4, T5, T6, T7, T8, T9, R>): Internal.App<F, R>;
        apply<R>(arg0: Internal.Applicative_<F, any>, arg1: Internal.App_<F, Internal.Function9<T1, T2, T3, T4, T5, T6, T7, T8, T9, R>>): Internal.App<F, R>;
    }
    type Products$P9_<F extends Internal.K1, T1, T2, T3, T4, T5, T6, T7, T8, T9> = Products$P9<F, T1, T2, T3, T4, T5, T6, T7, T8, T9>;
    class Products$P8 <F extends Internal.K1, T1, T2, T3, T4, T5, T6, T7, T8> {
        constructor(arg0: Internal.App_<F, T1>, arg1: Internal.App_<F, T2>, arg2: Internal.App_<F, T3>, arg3: Internal.App_<F, T4>, arg4: Internal.App_<F, T5>, arg5: Internal.App_<F, T6>, arg6: Internal.App_<F, T7>, arg7: Internal.App_<F, T8>)
        t1(): Internal.App<F, T1>;
        t2(): Internal.App<F, T2>;
        t3(): Internal.App<F, T3>;
        t6(): Internal.App<F, T6>;
        t8(): Internal.App<F, T8>;
        t7(): Internal.App<F, T7>;
        t4(): Internal.App<F, T4>;
        t5(): Internal.App<F, T5>;
        apply<R>(arg0: Internal.Applicative_<F, any>, arg1: Internal.Function8_<T1, T2, T3, T4, T5, T6, T7, T8, R>): Internal.App<F, R>;
        apply<R>(arg0: Internal.Applicative_<F, any>, arg1: Internal.App_<F, Internal.Function8<T1, T2, T3, T4, T5, T6, T7, T8, R>>): Internal.App<F, R>;
    }
    type Products$P8_<F extends Internal.K1, T1, T2, T3, T4, T5, T6, T7, T8> = Products$P8<F, T1, T2, T3, T4, T5, T6, T7, T8>;
    class MoltenGoldFluid$Flowing extends Internal.MoltenGoldFluid {
        constructor(properties: Internal.ModFlowingFluid$Properties_, block: Internal.Supplier_<Internal.LiquidBlock>)
        arch$holder(): Internal.Holder<Internal.Fluid>;
        arch$registryName(): ResourceLocation;
    }
    type MoltenGoldFluid$Flowing_ = MoltenGoldFluid$Flowing;
    class IdentityHashMap <K, V> extends Internal.AbstractMap<K, V> implements Internal.Cloneable, Internal.Map<K, V>, Internal.Serializable {
        constructor(arg0: Internal.Map_<K, V>)
        constructor()
        constructor(arg0: number)
        clone(): any;
        computeIfAbsent(arg0: K, arg1: Internal.Function_<K, V>): V;
        replace(arg0: K, arg1: V): V;
        static of<K, V>(): Internal.Map<K, V>;
        computeIfPresent(arg0: K, arg1: Internal.BiFunction_<K, V, V>): V;
        getOrDefault(arg0: any, arg1: V): V;
        static entry<K, V>(arg0: K, arg1: V): Internal.Map$Entry<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V): Internal.Map<K, V>;
        put(arg0: K, arg1: V): V;
        get(arg0: any): V;
        remove(arg0: any): V;
        static copyOf<K, V>(arg0: Internal.Map_<K, V>): Internal.Map<K, V>;
        merge(arg0: K, arg1: V, arg2: Internal.BiFunction_<V, V, V>): V;
        keySet(): Internal.Set<K>;
        putIfAbsent(arg0: K, arg1: V): V;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V): Internal.Map<K, V>;
        values(): Internal.Collection<V>;
        entrySet(): Internal.Set<Internal.Map$Entry<K, V>>;
        compute(arg0: K, arg1: Internal.BiFunction_<K, V, V>): V;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V, arg16: K, arg17: V, arg18: K, arg19: V): Internal.Map<K, V>;
        static ofEntries<K, V>(...arg0: Internal.Map$Entry_<K, V>[]): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V, arg16: K, arg17: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V): Internal.Map<K, V>;
    }
    type IdentityHashMap_<K, V> = IdentityHashMap<K, V>;
    class Products$P5 <F extends Internal.K1, T1, T2, T3, T4, T5> {
        constructor(arg0: Internal.App_<F, T1>, arg1: Internal.App_<F, T2>, arg2: Internal.App_<F, T3>, arg3: Internal.App_<F, T4>, arg4: Internal.App_<F, T5>)
        apply<R>(arg0: Internal.Applicative_<F, any>, arg1: Internal.Function5_<T1, T2, T3, T4, T5, R>): Internal.App<F, R>;
        t1(): Internal.App<F, T1>;
        t2(): Internal.App<F, T2>;
        t3(): Internal.App<F, T3>;
        t4(): Internal.App<F, T4>;
        t5(): Internal.App<F, T5>;
        and<T6>(arg0: Internal.App_<F, T6>): Internal.Products$P6<F, T1, T2, T3, T4, T5, T6>;
        and<T6, T7>(arg0: Internal.Products$P2_<F, T6, T7>): Internal.Products$P7<F, T1, T2, T3, T4, T5, T6, T7>;
        apply<R>(arg0: Internal.Applicative_<F, any>, arg1: Internal.App_<F, Internal.Function5<T1, T2, T3, T4, T5, R>>): Internal.App<F, R>;
        and<T6, T7, T8>(arg0: Internal.Products$P3_<F, T6, T7, T8>): Internal.Products$P8<F, T1, T2, T3, T4, T5, T6, T7, T8>;
    }
    type Products$P5_<F extends Internal.K1, T1, T2, T3, T4, T5> = Products$P5<F, T1, T2, T3, T4, T5>;
    class Products$P4 <F extends Internal.K1, T1, T2, T3, T4> {
        constructor(arg0: Internal.App_<F, T1>, arg1: Internal.App_<F, T2>, arg2: Internal.App_<F, T3>, arg3: Internal.App_<F, T4>)
        t1(): Internal.App<F, T1>;
        t2(): Internal.App<F, T2>;
        t3(): Internal.App<F, T3>;
        t4(): Internal.App<F, T4>;
        apply<R>(arg0: Internal.Applicative_<F, any>, arg1: Internal.App_<F, Internal.Function4<T1, T2, T3, T4, R>>): Internal.App<F, R>;
        and<T5>(arg0: Internal.App_<F, T5>): Internal.Products$P5<F, T1, T2, T3, T4, T5>;
        apply<R>(arg0: Internal.Applicative_<F, any>, arg1: Internal.Function4_<T1, T2, T3, T4, R>): Internal.App<F, R>;
        and<T5, T6, T7, T8>(arg0: Internal.Products$P4_<F, T5, T6, T7, T8>): Internal.Products$P8<F, T1, T2, T3, T4, T5, T6, T7, T8>;
        and<T5, T6, T7>(arg0: Internal.Products$P3_<F, T5, T6, T7>): Internal.Products$P7<F, T1, T2, T3, T4, T5, T6, T7>;
        and<T5, T6>(arg0: Internal.Products$P2_<F, T5, T6>): Internal.Products$P6<F, T1, T2, T3, T4, T5, T6>;
    }
    type Products$P4_<F extends Internal.K1, T1, T2, T3, T4> = Products$P4<F, T1, T2, T3, T4>;
    class RenderStateShard$ColorLogicStateShard extends Internal.RenderStateShard {
        constructor($$0: string, $$1: Internal.Runnable_, $$2: Internal.Runnable_)
        static getTranslucentTransparency(): Internal.RenderStateShard$TransparencyStateShard;
        static getGLINT_TRANSPARENCY(): Internal.RenderStateShard$TransparencyStateShard;
        static getCRUMBLING_TRANSPARENCY(): Internal.RenderStateShard$TransparencyStateShard;
        static getNO_TRANSPARENCY(): Internal.RenderStateShard$TransparencyStateShard;
        get translucentTransparency(): Internal.RenderStateShard$TransparencyStateShard
        get GLINT_TRANSPARENCY(): Internal.RenderStateShard$TransparencyStateShard
        get CRUMBLING_TRANSPARENCY(): Internal.RenderStateShard$TransparencyStateShard
        get NO_TRANSPARENCY(): Internal.RenderStateShard$TransparencyStateShard
    }
    type RenderStateShard$ColorLogicStateShard_ = RenderStateShard$ColorLogicStateShard;
    class TrackCouplerDisplaySource extends Internal.DisplaySource {
        constructor()
    }
    type TrackCouplerDisplaySource_ = TrackCouplerDisplaySource;
    class Products$P7 <F extends Internal.K1, T1, T2, T3, T4, T5, T6, T7> {
        constructor(arg0: Internal.App_<F, T1>, arg1: Internal.App_<F, T2>, arg2: Internal.App_<F, T3>, arg3: Internal.App_<F, T4>, arg4: Internal.App_<F, T5>, arg5: Internal.App_<F, T6>, arg6: Internal.App_<F, T7>)
        t1(): Internal.App<F, T1>;
        t2(): Internal.App<F, T2>;
        t3(): Internal.App<F, T3>;
        t6(): Internal.App<F, T6>;
        t7(): Internal.App<F, T7>;
        t4(): Internal.App<F, T4>;
        t5(): Internal.App<F, T5>;
        and<T8>(arg0: Internal.App_<F, T8>): Internal.Products$P8<F, T1, T2, T3, T4, T5, T6, T7, T8>;
        apply<R>(arg0: Internal.Applicative_<F, any>, arg1: Internal.Function7_<T1, T2, T3, T4, T5, T6, T7, R>): Internal.App<F, R>;
        apply<R>(arg0: Internal.Applicative_<F, any>, arg1: Internal.App_<F, Internal.Function7<T1, T2, T3, T4, T5, T6, T7, R>>): Internal.App<F, R>;
    }
    type Products$P7_<F extends Internal.K1, T1, T2, T3, T4, T5, T6, T7> = Products$P7<F, T1, T2, T3, T4, T5, T6, T7>;
    class Products$P6 <F extends Internal.K1, T1, T2, T3, T4, T5, T6> {
        constructor(arg0: Internal.App_<F, T1>, arg1: Internal.App_<F, T2>, arg2: Internal.App_<F, T3>, arg3: Internal.App_<F, T4>, arg4: Internal.App_<F, T5>, arg5: Internal.App_<F, T6>)
        t1(): Internal.App<F, T1>;
        t2(): Internal.App<F, T2>;
        t3(): Internal.App<F, T3>;
        t6(): Internal.App<F, T6>;
        t4(): Internal.App<F, T4>;
        t5(): Internal.App<F, T5>;
        apply<R>(arg0: Internal.Applicative_<F, any>, arg1: Internal.Function6_<T1, T2, T3, T4, T5, T6, R>): Internal.App<F, R>;
        and<T7, T8>(arg0: Internal.Products$P2_<F, T7, T8>): Internal.Products$P8<F, T1, T2, T3, T4, T5, T6, T7, T8>;
        apply<R>(arg0: Internal.Applicative_<F, any>, arg1: Internal.App_<F, Internal.Function6<T1, T2, T3, T4, T5, T6, R>>): Internal.App<F, R>;
        and<T7>(arg0: Internal.App_<F, T7>): Internal.Products$P7<F, T1, T2, T3, T4, T5, T6, T7>;
    }
    type Products$P6_<F extends Internal.K1, T1, T2, T3, T4, T5, T6> = Products$P6<F, T1, T2, T3, T4, T5, T6>;
    class CarriageBogey implements Internal.AccessorCarriageBogey {
        constructor(type: Internal.AbstractBogeyBlock_<any>, upsideDown: boolean, bogeyData: Internal.CompoundTag_, point: Internal.TravellingPoint_, point2: Internal.TravellingPoint_)
        getAnchorPosition(): Vec3d;
        getType(): Internal.AbstractBogeyBlock<any>;
        getStress(): number;
        updateCouplingAnchor(entityPos: Vec3d_, entityXRot: number, entityYRot: number, bogeySpacing: number, partialTicks: number, leading: boolean): void;
        getSize(): Internal.BogeySizes$BogeySize;
        static read(tag: Internal.CompoundTag_, graph: Internal.TrackGraph_, dimensions: Internal.DimensionPalette_): Internal.CarriageBogey;
        getAnchorPosition(flipUpsideDown: boolean): Vec3d;
        write(dimensions: Internal.DimensionPalette_): Internal.CompoundTag;
        isUpsideDown(): boolean;
        getDimension(): Internal.ResourceKey<Internal.Level>;
        trailing(): Internal.TravellingPoint;
        updateAngles(entity: Internal.CarriageContraptionEntity_, distanceMoved: number): void;
        getStyle(): Internal.BogeyStyle;
        leading(): Internal.TravellingPoint;
        get anchorPosition(): Vec3d
        get type(): Internal.AbstractBogeyBlock<any>
        get stress(): number
        get size(): Internal.BogeySizes$BogeySize
        get upsideDown(): boolean
        get dimension(): Internal.ResourceKey<Internal.Level>
        get style(): Internal.BogeyStyle
        carriage: Internal.Carriage;
        couplingAnchors: Internal.Couple<Vec3d>;
        bogeyData: Internal.CompoundTag;
        static readonly UPSIDE_DOWN_KEY: "UpsideDown";
    }
    type CarriageBogey_ = CarriageBogey;
    class EnchantPowerDisplaySource extends Internal.NumericSingleLineDisplaySource {
        constructor()
    }
    type EnchantPowerDisplaySource_ = EnchantPowerDisplaySource;
    class RegistrateBlockstateProvider extends io.github.fabricators_of_create.porting_lib.models.generators.block.BlockStateProvider implements Internal.RegistrateProvider {
        constructor(parent: Internal.AbstractRegistrate_<any>, packOutput: Internal.PackOutput_, exFileHelper: Internal.ExistingFileHelper_)
        getExistingVariantBuilder(block: Internal.Block_): Internal.Optional<Internal.VariantBlockStateBuilder>;
        getExistingMultipartBuilder(block: Internal.Block_): Internal.Optional<Internal.MultiPartBlockStateBuilder>;
        getSide(): Internal.EnvType;
        static saveStable($$0: Internal.CachedOutput_, $$1: Internal.JsonElement_, $$2: Internal.Path_): Internal.CompletableFuture<any>;
        get side(): Internal.EnvType
    }
    type RegistrateBlockstateProvider_ = RegistrateBlockstateProvider;
    class TrimMaterial extends Internal.Record {
        constructor($$0: string, $$1: Internal.Holder_<Internal.Item>, $$2: number, $$3: Internal.Map_<Internal.ArmorMaterials, string>, $$4: net.minecraft.network.chat.Component_)
        description(): net.minecraft.network.chat.Component;
        ingredient(): Internal.Holder<Internal.Item>;
        assetName(): string;
        static create($$0: string, $$1: Internal.Item_, $$2: number, $$3: net.minecraft.network.chat.Component_, $$4: Internal.Map_<Internal.ArmorMaterials, string>): Internal.TrimMaterial;
        itemModelIndex(): number;
        overrideArmorMaterials(): Internal.Map<Internal.ArmorMaterials, string>;
        static readonly CODEC: Internal.Codec<Internal.Holder<Internal.TrimMaterial>>;
        static readonly DIRECT_CODEC: Internal.Codec<Internal.TrimMaterial>;
    }
    type TrimMaterial_ = Special.TrimMaterial | TrimMaterial;
    interface VoxelShapeCaster {
        abstract intersects(arg0: Internal.AABB_, arg1: number, arg2: number, arg3: number): boolean;
        (arg0: Internal.AABB, arg1: number, arg2: number, arg3: number): boolean;
    }
    type VoxelShapeCaster_ = VoxelShapeCaster;
    interface ModelBaker {
        abstract bake(arg0: ResourceLocation_, arg1: Internal.ModelState_): Internal.BakedModel;
        abstract getModel(arg0: ResourceLocation_): Internal.UnbakedModel;
    }
    type ModelBaker_ = ModelBaker;
    class ParticleSpray$Companion {
        constructor($constructor_marker: any_)
        static cloud$default(arg0: Internal.ParticleSpray$Companion_, arg1: Vec3d_, arg2: number, arg3: number, arg4: number, arg5: any): Internal.ParticleSpray;
        cloud(pos: Vec3d_, size: number, count: number): Internal.ParticleSpray;
        burst(pos: Vec3d_, size: number, count: number): Internal.ParticleSpray;
        static burst$default(arg0: Internal.ParticleSpray$Companion_, arg1: Vec3d_, arg2: number, arg3: number, arg4: number, arg5: any): Internal.ParticleSpray;
    }
    type ParticleSpray$Companion_ = ParticleSpray$Companion;
    class ConfiguredModel$Builder <T> {
        uvLock(value: boolean): this;
        addModel(): T;
        buildLast(): Internal.ConfiguredModel;
        build(): Internal.ConfiguredModel[];
        rotationY(value: number): this;
        rotationX(value: number): this;
        nextModel(): this;
        weight(value: number): this;
        modelFile(model: Internal.ModelFile_): this;
    }
    type ConfiguredModel$Builder_<T> = ConfiguredModel$Builder<T>;
    class SoundEvent {
        getLocation(): ResourceLocation;
        getRange($$0: number): number;
        static readFromNetwork($$0: Internal.FriendlyByteBuf_): Internal.SoundEvent;
        static createVariableRangeEvent($$0: ResourceLocation_): Internal.SoundEvent;
        writeToNetwork($$0: Internal.FriendlyByteBuf_): void;
        static createFixedRangeEvent($$0: ResourceLocation_, $$1: number): Internal.SoundEvent;
        get location(): ResourceLocation
        static readonly DIRECT_CODEC: Internal.Codec<Internal.SoundEvent>;
        static readonly CODEC: Internal.Codec<Internal.Holder<Internal.SoundEvent>>;
    }
    type SoundEvent_ = SoundEvent | Special.SoundEvent;
    interface ChannelOutboundInvoker {
        abstract newFailedFuture(arg0: Internal.Throwable_): Internal.ChannelFuture;
        abstract connect(arg0: Internal.SocketAddress_, arg1: Internal.SocketAddress_, arg2: Internal.ChannelPromise_): Internal.ChannelFuture;
        abstract close(arg0: Internal.ChannelPromise_): Internal.ChannelFuture;
        abstract deregister(arg0: Internal.ChannelPromise_): Internal.ChannelFuture;
        abstract newSucceededFuture(): Internal.ChannelFuture;
        abstract newProgressivePromise(): Internal.ChannelProgressivePromise;
        abstract flush(): this;
        abstract write(arg0: any): Internal.ChannelFuture;
        abstract writeAndFlush(arg0: any): Internal.ChannelFuture;
        abstract bind(arg0: Internal.SocketAddress_, arg1: Internal.ChannelPromise_): Internal.ChannelFuture;
        abstract disconnect(): Internal.ChannelFuture;
        abstract writeAndFlush(arg0: any, arg1: Internal.ChannelPromise_): Internal.ChannelFuture;
        abstract close(): Internal.ChannelFuture;
        abstract bind(arg0: Internal.SocketAddress_): Internal.ChannelFuture;
        abstract write(arg0: any, arg1: Internal.ChannelPromise_): Internal.ChannelFuture;
        abstract connect(arg0: Internal.SocketAddress_): Internal.ChannelFuture;
        abstract connect(arg0: Internal.SocketAddress_, arg1: Internal.SocketAddress_): Internal.ChannelFuture;
        abstract connect(arg0: Internal.SocketAddress_, arg1: Internal.ChannelPromise_): Internal.ChannelFuture;
        abstract read(): this;
        abstract deregister(): Internal.ChannelFuture;
        abstract voidPromise(): Internal.ChannelPromise;
        abstract disconnect(arg0: Internal.ChannelPromise_): Internal.ChannelFuture;
        abstract newPromise(): Internal.ChannelPromise;
    }
    type ChannelOutboundInvoker_ = ChannelOutboundInvoker;
    interface AccessorItemCooldowns {
        abstract bookshelf$getCooldowns(): Internal.Map<Internal.Item, any>;
        abstract bookshelf$getTickCount(): number;
    }
    type AccessorItemCooldowns_ = AccessorItemCooldowns;
    class VoidUpgradeItem extends Internal.UpgradeItemBase<Internal.VoidUpgradeWrapper> {
        constructor(voidUpgradeConfig: any_, upgradeTypeLimitConfig: any_)
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        checkThisForConflictsWithExistingUpgrades(upgradeStack: Internal.ItemStack_, storageWrapper: Internal.IStorageWrapper_, excludeUpgradeSlot: number): Internal.UpgradeSlotChangeResult;
        getFilterSlotCount(): number;
        canRemoveUpgradeFrom(storageWrapper: Internal.IStorageWrapper_, isClientSide: boolean, player: Internal.Player_): Internal.UpgradeSlotChangeResult;
        setAttackSpeed(attackSpeed: number): void;
        getCleanedUpgradeStack(upgradeStack: Internal.ItemStack_): Internal.ItemStack;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        getInventoryColumnsTaken(): number;
        getCreativeTab(): string;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        canAddUpgradeTo(storageWrapper: Internal.IStorageWrapper_, upgradeStack: Internal.ItemStack_, firstLevelStorage: boolean, isClientSide: boolean): Internal.UpgradeSlotChangeResult;
        emi(): Internal.EmiStack;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isVoidAnythingEnabled(): boolean;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        setArmorToughness(armorToughness: number): void;
        getType(): Internal.UpgradeType<Internal.VoidUpgradeWrapper>;
        canSwapUpgradeFor(upgradeStackToPut: Internal.ItemStack_, upgradeSlot: number, storageWrapper: Internal.IStorageWrapper_, isClientSide: boolean): Internal.UpgradeSlotChangeResult;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        checkExtraInsertConditions(upgradeStack: Internal.ItemStack_, storageWrapper: Internal.IStorageWrapper_, isClientSide: boolean, upgradeInSlot: Internal.IUpgradeItem_<any>): Internal.UpgradeSlotChangeResult;
        emi(amount: number): Internal.EmiStack;
        getUpgradeGroup(): Internal.UpgradeGroup;
        canRemoveUpgradeFrom(storageWrapper: Internal.IStorageWrapper_, isClientSide: boolean): Internal.UpgradeSlotChangeResult;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        set digSpeed(speed: number)
        get filterSlotCount(): number
        set attackSpeed(attackSpeed: number)
        get inventoryColumnsTaken(): number
        get creativeTab(): string
        set armorKnockbackResistance(knockbackResistance: number)
        get voidAnythingEnabled(): boolean
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        set armorToughness(armorToughness: number)
        get type(): Internal.UpgradeType<Internal.VoidUpgradeWrapper>
        get upgradeGroup(): Internal.UpgradeGroup
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        static readonly TYPE: Internal.UpgradeType<Internal.VoidUpgradeWrapper>;
    }
    type VoidUpgradeItem_ = VoidUpgradeItem;
    interface ReflectionAccessFilter {
        abstract check(arg0: typeof any): Internal.ReflectionAccessFilter$FilterResult;
        (arg0: typeof any): Internal.ReflectionAccessFilter$FilterResult_;
        readonly BLOCK_ALL_JAVA: Internal.ReflectionAccessFilter;
        readonly BLOCK_ALL_ANDROID: Internal.ReflectionAccessFilter;
        readonly BLOCK_INACCESSIBLE_JAVA: Internal.ReflectionAccessFilter;
        readonly BLOCK_ALL_PLATFORM: Internal.ReflectionAccessFilter;
    }
    type ReflectionAccessFilter_ = ReflectionAccessFilter;
    class GrassSplatterFeature extends Internal.Feature<Internal.NoneFeatureConfiguration> {
        constructor(deserializer: Internal.Codec_<Internal.NoneFeatureConfiguration>)
        static isAir(level: Internal.LevelSimulatedReader_, pos: BlockPos_): boolean;
    }
    type GrassSplatterFeature_ = GrassSplatterFeature;
    class BlockStateModifyPlacementCallbackJS extends Internal.BlockStateModifyCallbackJS {
        constructor(context: Internal.BlockPlaceContext_, block: Internal.Block_)
        /**
         * Gets the facing direction of the clicked block face
        */
        getClickedFace(): Internal.Direction;
        /**
         * Gets the clicked block
        */
        getClickedBlock(): Internal.BlockContainerJS;
        /**
         * Gets an array of all directions, ordered by which the player is looking closest to
        */
        getNearestLookingDirections(): Internal.Direction[];
        /**
         * Gets the item being placed
        */
        getItem(): Internal.ItemStack;
        /**
         * Gets the nearest horizontal direction to where the player is looking. NORTH if there is no player
        */
        getHorizontalDirection(): Internal.Direction;
        /**
         * Get the horizontal rotation of the player
        */
        getRotation(): number;
        /**
         * Returns if the block being placed thinks it can be placed here. This is used for replacement checks, like placing blocks in water or tall grass
        */
        canPlace(): boolean;
        /**
         * Set this block as waterlogged if it is in water
        */
        waterlogged(): this;
        /**
         * Gets the FluidSate at the clicked position
        */
        getFluidStateAtClickedPos(): Internal.FluidState;
        /**
         * Checks if this block is in water
        */
        isInWater(): boolean;
        /**
         * Gets the level
        */
        getLevel(): Internal.Level;
        /**
         * Gets the direction closes to where the player is currently looking
        */
        getNearestLookingDirection(): Internal.Direction;
        /**
         * Gets the position in the block-space of where it was clicked
        */
        getClickLocation(): Vec3d;
        /**
         * Returns if the player is using the 'secondary' function of this item. Basically checks if they are holding shift
        */
        isSecondaryUseActive(): boolean;
        /**
         * Checks if the position clicked has a specified fluid there
        */
        isClickedPosIn(fluid: Internal.Fluid_): boolean;
        /**
         * Gets the vertical direction (UP/DOWN) closest to where the player is currently looking
        */
        getNearestLookingVerticalDirection(): Internal.Direction;
        /**
         * Returns if the block being placed is replacing the block clicked
        */
        replacingClickedOnBlock(): boolean;
        /**
         * Gets the hand that is placing the block
        */
        getHand(): Internal.InteractionHand;
        /**
         * Gets the clicked position in world
        */
        getClickedPos(): BlockPos;
        /**
         * Gets the player placing the block, if available
        */
        getPlayer(): Internal.Player;
        /**
         * Returns if the hit posiiton in the block-space is inside the 1x1x1 cube of the block
        */
        isInside(): boolean;
        /**
         * Checks if the block currently occupying the position this is being placed in is the same block type.
         * Used for things like candles, where multiple can be in the same block-space.
        */
        isReplacingSelf(): boolean;
        /**
         * Set if this block is waterlogged or not
        */
        waterlogged(waterlogged: boolean): this;
        /**
         * Gets the facing direction of the clicked block face
        */
        get clickedFace(): Internal.Direction
        /**
         * Gets the clicked block
        */
        get clickedBlock(): Internal.BlockContainerJS
        /**
         * Gets an array of all directions, ordered by which the player is looking closest to
        */
        get nearestLookingDirections(): Internal.Direction[]
        /**
         * Gets the item being placed
        */
        get item(): Internal.ItemStack
        /**
         * Gets the nearest horizontal direction to where the player is looking. NORTH if there is no player
        */
        get horizontalDirection(): Internal.Direction
        /**
         * Get the horizontal rotation of the player
        */
        get rotation(): number
        /**
         * Gets the FluidSate at the clicked position
        */
        get fluidStateAtClickedPos(): Internal.FluidState
        /**
         * Checks if this block is in water
        */
        get inWater(): boolean
        /**
         * Gets the level
        */
        get level(): Internal.Level
        /**
         * Gets the direction closes to where the player is currently looking
        */
        get nearestLookingDirection(): Internal.Direction
        /**
         * Gets the position in the block-space of where it was clicked
        */
        get clickLocation(): Vec3d
        /**
         * Returns if the player is using the 'secondary' function of this item. Basically checks if they are holding shift
        */
        get secondaryUseActive(): boolean
        /**
         * Gets the vertical direction (UP/DOWN) closest to where the player is currently looking
        */
        get nearestLookingVerticalDirection(): Internal.Direction
        /**
         * Gets the hand that is placing the block
        */
        get hand(): Internal.InteractionHand
        /**
         * Gets the clicked position in world
        */
        get clickedPos(): BlockPos
        /**
         * Gets the player placing the block, if available
        */
        get player(): Internal.Player
        /**
         * Returns if the hit posiiton in the block-space is inside the 1x1x1 cube of the block
        */
        get inside(): boolean
        /**
         * Checks if the block currently occupying the position this is being placed in is the same block type.
         * Used for things like candles, where multiple can be in the same block-space.
        */
        get replacingSelf(): boolean
        readonly context: Internal.BlockPlaceContext;
        block: Internal.BlockContainerJS;
        readonly minecraftBlock: Internal.Block;
    }
    type BlockStateModifyPlacementCallbackJS_ = BlockStateModifyPlacementCallbackJS;
    class PlantType {
        static get(name: string): Internal.PlantType;
        getName(): string;
        get name(): string
        static readonly PLAINS: Internal.PlantType;
        static readonly CROP: Internal.PlantType;
        static readonly WATER: Internal.PlantType;
        static readonly BEACH: Internal.PlantType;
        static readonly CAVE: Internal.PlantType;
        static readonly DESERT: Internal.PlantType;
        static readonly NETHER: Internal.PlantType;
    }
    type PlantType_ = PlantType;
    class PlayerInfo {
        constructor($$0: Internal.GameProfile_, $$1: boolean)
        getTabListDisplayName(): net.minecraft.network.chat.Component;
        getModelName(): string;
        getTeam(): Internal.PlayerTeam;
        getChatSession(): Internal.RemoteChatSession;
        getMessageValidator(): Internal.SignedMessageValidator;
        getElytraLocation(): ResourceLocation;
        setTabListDisplayName($$0: net.minecraft.network.chat.Component_): void;
        getCapeLocation(): ResourceLocation;
        getProfile(): Internal.GameProfile;
        getSkinLocation(): ResourceLocation;
        getGameMode(): Internal.GameType;
        isSkinLoaded(): boolean;
        getLatency(): number;
        isCapeLoaded(): boolean;
        hasVerifiableChat(): boolean;
        get tabListDisplayName(): net.minecraft.network.chat.Component
        get modelName(): string
        get team(): Internal.PlayerTeam
        get chatSession(): Internal.RemoteChatSession
        get messageValidator(): Internal.SignedMessageValidator
        get elytraLocation(): ResourceLocation
        set tabListDisplayName($$0: net.minecraft.network.chat.Component_)
        get capeLocation(): ResourceLocation
        get profile(): Internal.GameProfile
        get skinLocation(): ResourceLocation
        get gameMode(): Internal.GameType
        get skinLoaded(): boolean
        get latency(): number
        get capeLoaded(): boolean
    }
    type PlayerInfo_ = PlayerInfo;
    class LumaloopFeature extends Internal.Feature<Internal.NoneFeatureConfiguration> {
        constructor(p_67292_: Internal.Codec_<Internal.NoneFeatureConfiguration>)
        static placeWeepingVinesColumn(p_225301_: Internal.LevelAccessor_, p_225302_: Internal.RandomSource_, p_225303_: Internal.BlockPos$MutableBlockPos_, p_225304_: number, p_225305_: number, p_225306_: number): void;
    }
    type LumaloopFeature_ = LumaloopFeature;
    class PointedDripstoneBlock extends Internal.Block implements Internal.Fallable, Internal.SimpleWaterloggedBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        static findStalactiteTipAboveCauldron($$0: Internal.Level_, $$1: BlockPos_): BlockPos;
        static getCauldronFillFluidType($$0: Internal.ServerLevel_, $$1: BlockPos_): Internal.Fluid;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        onLand($$0: Internal.Level_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.BlockState_, $$4: Internal.FallingBlockEntity_): void;
        setRequiresTool(v: boolean): void;
        onBrokenAfterFall($$0: Internal.Level_, $$1: BlockPos_, $$2: Internal.FallingBlockEntity_): void;
        static canDrip($$0: Internal.BlockState_): boolean;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static spawnDripParticle($$0: Internal.Level_, $$1: BlockPos_, $$2: Internal.BlockState_): void;
        static maybeTransferFluid(state: Internal.BlockState_, world: Internal.ServerLevel_, pos: BlockPos_, dripChance: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getFallDamageSource($$0: Internal.Entity_): DamageSource;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        static growStalactiteOrStalagmiteIfPossible($$0: Internal.BlockState_, $$1: Internal.ServerLevel_, $$2: BlockPos_, $$3: Internal.RandomSource_): void;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly THICKNESS: Internal.EnumProperty<Internal.DripstoneThickness>;
        static readonly TIP_DIRECTION: Internal.DirectionProperty;
        static readonly WATERLOGGED: Internal.BooleanProperty;
    }
    type PointedDripstoneBlock_ = PointedDripstoneBlock;
    interface SchematicPrinter$BlockTargetHandler {
        abstract handle(arg0: BlockPos_, arg1: Internal.BlockState_, arg2: Internal.BlockEntity_): void;
        (arg0: BlockPos, arg1: Internal.BlockState, arg2: Internal.BlockEntity): void;
    }
    type SchematicPrinter$BlockTargetHandler_ = SchematicPrinter$BlockTargetHandler;
    class CapacityEnchantment extends Internal.Enchantment implements Internal.CustomEnchantingTableBehaviorEnchantment {
        constructor(rarity: Internal.Enchantment$Rarity_, category: Internal.EnchantmentCategory_, slots: Internal.EquipmentSlot_[])
        canApplyAtEnchantingTable(stack: Internal.ItemStack_): boolean;
    }
    type CapacityEnchantment_ = CapacityEnchantment;
    interface ShaderProgramAccessor {
        abstract owo$getLoadedUniforms(): Internal.Map<string, Internal.Uniform>;
        (): Internal.Map_<string, Internal.Uniform>;
    }
    type ShaderProgramAccessor_ = ShaderProgramAccessor;
    interface BlockElementFaceExtensions {
        abstract port_lib$getRenderMaterial(): Internal.MaterialData;
        abstract port_lib$setRenderMaterial(arg0: Internal.MaterialData_): void;
    }
    type BlockElementFaceExtensions_ = BlockElementFaceExtensions;
    class ClientboundPlayerAbilitiesPacket implements Internal.Packet<Internal.ClientGamePacketListener>, Internal.ClientboundPlayerAbilitiesPacketAccessor {
        constructor($$0: Internal.FriendlyByteBuf_)
        constructor($$0: Internal.Abilities_)
        handle(arg0: Internal.PacketListener_): void;
        write($$0: Internal.FriendlyByteBuf_): void;
        port_lib$setFlyingSpeed(arg0: number): void;
        canInstabuild(): boolean;
        canFly(): boolean;
        handle($$0: Internal.ClientGamePacketListener_): void;
        getFlyingSpeed(): number;
        getWalkingSpeed(): number;
        isInvulnerable(): boolean;
        isSkippable(): boolean;
        isFlying(): boolean;
        get flyingSpeed(): number
        get walkingSpeed(): number
        get invulnerable(): boolean
        get skippable(): boolean
        get flying(): boolean
    }
    type ClientboundPlayerAbilitiesPacket_ = ClientboundPlayerAbilitiesPacket;
    class LastSeenMessages extends Internal.Record {
        constructor($$0: Internal.List_<Internal.MessageSignature>)
        updateSignature($$0: Internal.SignatureUpdater$Output_): void;
        entries(): Internal.List<Internal.MessageSignature>;
        pack($$0: Internal.MessageSignatureCache_): Internal.LastSeenMessages$Packed;
        static readonly CODEC: Internal.Codec<Internal.LastSeenMessages>;
        static readonly LAST_SEEN_MESSAGES_MAX_LENGTH: 20;
        static EMPTY: Internal.LastSeenMessages;
    }
    type LastSeenMessages_ = LastSeenMessages;
    class SlabBlock extends Internal.Block implements Internal.SimpleWaterloggedBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly WATERLOGGED: Internal.BooleanProperty;
        static readonly TYPE: Internal.EnumProperty<Internal.SlabType>;
    }
    type SlabBlock_ = SlabBlock;
    class DimensionType extends Internal.Record implements Internal.DimensionTypeAccessor {
        constructor($$0: Internal.OptionalLong_, $$1: boolean, $$2: boolean, $$3: boolean, $$4: boolean, $$5: number, $$6: boolean, $$7: boolean, $$8: number, $$9: number, $$10: number, $$11: Internal.TagKey_<Internal.Block>, $$12: ResourceLocation_, $$13: number, $$14: Internal.DimensionType$MonsterSettings_)
        monsterSettings(): Internal.DimensionType$MonsterSettings;
        /**
         * @deprecated
        */
        static parseLegacy($$0: Internal.Dynamic_<any>): Internal.DataResult<Internal.ResourceKey<Internal.Level>>;
        bedWorks(): boolean;
        respawnAnchorWorks(): boolean;
        coordinateScale(): number;
        piglinSafe(): boolean;
        hasFixedTime(): boolean;
        infiniburn(): Internal.TagKey<Internal.Block>;
        static getTeleportationScale($$0: Internal.DimensionType_, $$1: Internal.DimensionType_): number;
        getComp_641(): Internal.OptionalLong;
        effectsLocation(): ResourceLocation;
        fixedTime(): Internal.OptionalLong;
        monsterSpawnBlockLightLimit(): number;
        static getStorageFolder($$0: Internal.ResourceKey_<Internal.Level>, $$1: Internal.Path_): Internal.Path;
        hasCeiling(): boolean;
        hasSkyLight(): boolean;
        height(): number;
        ambientLight(): number;
        moonPhase($$0: number): number;
        natural(): boolean;
        timeOfDay($$0: number): number;
        minY(): number;
        logicalHeight(): number;
        ultraWarm(): boolean;
        hasRaids(): boolean;
        getComp_656(): number;
        monsterSpawnLightTest(): Internal.IntProvider;
        get comp_641(): Internal.OptionalLong
        get comp_656(): number
        static readonly MIN_HEIGHT: 16;
        static readonly MIN_Y: -2032;
        static readonly WAY_ABOVE_MAX_Y: 32496;
        static readonly Y_SIZE: 4064;
        static readonly MAX_Y: 2031;
        static readonly DIRECT_CODEC: Internal.Codec<Internal.DimensionType>;
        static readonly CODEC: Internal.Codec<Internal.Holder<Internal.DimensionType>>;
        static readonly BITS_FOR_Y: 12;
        static readonly WAY_BELOW_MIN_Y: -32512;
        static readonly MOON_BRIGHTNESS_PER_PHASE: number[];
    }
    type DimensionType_ = DimensionType | Special.DimensionType;
    class FacingSmokeStackBlock extends Internal.SmokeStackBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_, type: Internal.SmokeStackBlock$SmokeStackType_, shape: any_, createsStationarySmoke: boolean, variant: string)
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.SmokeStackBlockEntity>;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        updateWater(level: Internal.LevelAccessor_, state: Internal.BlockState_, pos: BlockPos_): void;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.SmokeStackBlockEntity;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        fluidState(state: Internal.BlockState_): Internal.FluidState;
        setRequiresTool(v: boolean): void;
        static withWater(level: Internal.LevelAccessor_, placementState: Internal.BlockState_, pos: BlockPos_): Internal.BlockState;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        withWater(placementState: Internal.BlockState_, ctx: Internal.BlockPlaceContext_): Internal.BlockState;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.SmokeStackBlockEntity>): void;
        emi(): Internal.EmiStack;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.SmokeStackBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly HORIZONTAL_FACING: Internal.DirectionProperty;
    }
    type FacingSmokeStackBlock_ = FacingSmokeStackBlock;
    abstract class HorizontalKineticBlock extends Internal.KineticBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        hideStressImpact(): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        getPreferredHorizontalFacing(context: Internal.BlockPlaceContext_): Internal.Direction;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        showCapacityWithAnnotation(): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        getMinimumRequiredSpeedLevel(): Internal.IRotate$SpeedLevel;
        emi(amount: number): Internal.EmiStack;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        get minimumRequiredSpeedLevel(): Internal.IRotate$SpeedLevel
        static readonly HORIZONTAL_FACING: Internal.DirectionProperty;
    }
    type HorizontalKineticBlock_ = HorizontalKineticBlock;
    class AttackIndicatorStatus extends Internal.Enum<Internal.AttackIndicatorStatus> implements Internal.OptionEnum {
        getKey(): string;
        static valueOf($$0: string): Internal.AttackIndicatorStatus;
        static values(): Internal.AttackIndicatorStatus[];
        getCaption(): net.minecraft.network.chat.Component;
        static byId($$0: number): Internal.AttackIndicatorStatus;
        getId(): number;
        get key(): string
        get caption(): net.minecraft.network.chat.Component
        get id(): number
        static readonly CROSSHAIR: Internal.AttackIndicatorStatus;
        static readonly OFF: Internal.AttackIndicatorStatus;
        static readonly HOTBAR: Internal.AttackIndicatorStatus;
    }
    type AttackIndicatorStatus_ = "hotbar" | "crosshair" | AttackIndicatorStatus | "off";
    abstract class AEBasePoweredItem extends Internal.AEBaseItem implements Internal.IAEItemPowerStorage {
        constructor(powerCapacity: Internal.DoubleSupplier_, props: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        getPowerFlow(is: Internal.ItemStack_): Internal.AccessRestriction;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        abstract getChargeRate(arg0: Internal.ItemStack_): number;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        getAEMaxPower(stack: Internal.ItemStack_): number;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        extractAEPower(stack: Internal.ItemStack_, amount: number, mode: Internal.Actionable_): number;
        injectAEPower(stack: Internal.ItemStack_, amount: number, mode: Internal.Actionable_): number;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        emi(): Internal.EmiStack;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        getAECurrentPower(is: Internal.ItemStack_): number;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type AEBasePoweredItem_ = AEBasePoweredItem;
    class CoderResult {
        isUnderflow(): boolean;
        isMalformed(): boolean;
        static malformedForLength(arg0: number): Internal.CoderResult;
        isError(): boolean;
        isUnmappable(): boolean;
        isOverflow(): boolean;
        throwException(): void;
        static unmappableForLength(arg0: number): Internal.CoderResult;
        length(): number;
        get underflow(): boolean
        get malformed(): boolean
        get error(): boolean
        get unmappable(): boolean
        get overflow(): boolean
        static readonly UNDERFLOW: Internal.CoderResult;
        static readonly OVERFLOW: Internal.CoderResult;
    }
    type CoderResult_ = CoderResult;
    class DarkOakFoliagePlacer extends Internal.FoliagePlacer {
        constructor($$0: Internal.IntProvider_, $$1: Internal.IntProvider_)
        static readonly CODEC: Internal.Codec<Internal.DarkOakFoliagePlacer>;
    }
    type DarkOakFoliagePlacer_ = DarkOakFoliagePlacer;
    class MoltenIronFluid$Source extends Internal.MoltenIronFluid {
        constructor(properties: Internal.ModFlowingFluid$Properties_, block: Internal.Supplier_<Internal.LiquidBlock>)
        arch$holder(): Internal.Holder<Internal.Fluid>;
        arch$registryName(): ResourceLocation;
    }
    type MoltenIronFluid$Source_ = MoltenIronFluid$Source;
    abstract class HttpAuthenticationService extends Internal.BaseAuthenticationService {
        static constantURL(arg0: string): Internal.URL;
        static concatenateURL(arg0: Internal.URL_, arg1: string): Internal.URL;
        static buildQuery(arg0: Internal.Map_<string, any>): string;
        performGetRequest(arg0: Internal.URL_): string;
        performPostRequest(arg0: Internal.URL_, arg1: string, arg2: string): string;
        getProxy(): Internal.Proxy;
        performGetRequest(arg0: Internal.URL_, arg1: string): string;
        get proxy(): Internal.Proxy
    }
    type HttpAuthenticationService_ = HttpAuthenticationService;
    class MultiplierNBT$Builder {
        build(): Internal.MultiplierNBT;
        set(stat: Internal.INumericToolStat_<any>, value: number): this;
    }
    type MultiplierNBT$Builder_ = MultiplierNBT$Builder;
    class TinkerStationDamagingRecipe implements Internal.ITinkerStationRecipe {
        constructor(id: ResourceLocation_, ingredient: Internal.Ingredient_, damageAmount: number)
        getGroup(): string;
        getValidatedResult(inv: Internal.ITinkerStationContainer_, registryAccess: Internal.RegistryAccess_): Internal.ValidatedResult;
        getToastSymbol(): Internal.ItemStack;
        getSchema(): Internal.RecipeSchema;
        /**
         * @deprecated
        */
        getRemainingItems(inv: Internal.ITinkerStationContainer_): Internal.NonNullList<Internal.ItemStack>;
        matches(inv: Internal.ITinkerStationContainer_, world: Internal.Level_): boolean;
        getSerializer(): Internal.RecipeSerializer<any>;
        assemble(arg0: net.minecraft.world.Container_, arg1: Internal.RegistryAccess_): Internal.ItemStack;
        getId(): ResourceLocation;
        updateInputs(result: Internal.ItemStack_, inv: Internal.IMutableTinkerStationContainer_, isServer: boolean): void;
        "handler$cfb000$fabric-item-api-v1$captureStack"(inventory: net.minecraft.world.Container_, cir: Internal.CallbackInfoReturnable_<any>, defaultedList: Internal.NonNullList_<any>, i: number): void;
        matches(arg0: net.minecraft.world.Container_, arg1: Internal.Level_): boolean;
        getMod(): string;
        getIngredients(): Internal.NonNullList<Internal.Ingredient>;
        isSpecial(): boolean;
        hasOutput(match: Internal.ReplacementMatch_): boolean;
        /**
         * @deprecated
        */
        getResultItem(registryAccess: Internal.RegistryAccess_): Internal.ItemStack;
        /**
         * @deprecated
        */
        getRemainingItems(arg0: net.minecraft.world.Container_): Internal.NonNullList<any>;
        shrinkToolSlotBy(): number;
        /**
         * @deprecated
        */
        canCraftInDimensions(width: number, height: number): boolean;
        showNotification(): boolean;
        replaceInput(match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        getType(): ResourceLocation;
        assemble(inv: Internal.ITinkerStationContainer_, registryAccess: Internal.RegistryAccess_): Internal.ItemStack;
        setGroup(group: string): void;
        getOrCreateId(): ResourceLocation;
        hasInput(match: Internal.ReplacementMatch_): boolean;
        isIncomplete(): boolean;
        replaceOutput(match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        get group(): string
        get toastSymbol(): Internal.ItemStack
        get schema(): Internal.RecipeSchema
        get serializer(): Internal.RecipeSerializer<any>
        get id(): ResourceLocation
        get mod(): string
        get ingredients(): Internal.NonNullList<Internal.Ingredient>
        get special(): boolean
        get type(): ResourceLocation
        set group(group: string)
        get orCreateId(): ResourceLocation
        get incomplete(): boolean
    }
    type TinkerStationDamagingRecipe_ = TinkerStationDamagingRecipe;
    class ItemAncientCypher extends Internal.ItemCypher {
        constructor(pProperties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        getConsumptionPriority(stack: Internal.ItemStack_): number;
        getVariant(stack: Internal.ItemStack_): number;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        insertMedia(stack: Internal.ItemStack_, amount: number, simulate: boolean): number;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        setVariant(stack: Internal.ItemStack_, variant: number): void;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        getMediaFullness(stack: Internal.ItemStack_): number;
        emi(amount: number): Internal.EmiStack;
        clampVariant(variant: number): number;
        withdrawMedia(stack: Internal.ItemStack_, cost: number, simulate: boolean): number;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        static readonly TAG_HEX_NAME: "hex_name";
        static readonly TAG_PATTERNS: "patterns";
    }
    type ItemAncientCypher_ = ItemAncientCypher;
    interface CustomMaxCountItem {
        abstract getItemStackLimit(arg0: Internal.ItemStack_): number;
        (arg0: Internal.ItemStack): number;
    }
    type CustomMaxCountItem_ = CustomMaxCountItem;
    interface IPartBuilderRecipe extends Internal.ICommonRecipe<Internal.IPartBuilderContainer> {
        getItemsUsed(inv: Internal.IPartBuilderContainer_): number;
        getGroup(): string;
        getToastSymbol(): Internal.ItemStack;
        getSchema(): Internal.RecipeSchema;
        getPatterns(inv: Internal.IPartBuilderContainer_): Internal.Stream<slimeknights.tconstruct.library.recipe.partbuilder.Pattern>;
        /**
         * @deprecated
        */
        getLeftover(inventoryWrapper: Internal.PartBuilderContainerWrapper_): Internal.ItemStack;
        abstract partialMatch(arg0: Internal.IPartBuilderContainer_): boolean;
        abstract getSerializer(): Internal.RecipeSerializer<any>;
        abstract getId(): ResourceLocation;
        abstract getCost(): number;
        getLeftover(inventoryWrapper: Internal.PartBuilderContainerWrapper_, pattern: slimeknights.tconstruct.library.recipe.partbuilder.Pattern_): Internal.ItemStack;
        "handler$cfb000$fabric-item-api-v1$captureStack"(inventory: net.minecraft.world.Container_, cir: Internal.CallbackInfoReturnable_<any>, defaultedList: Internal.NonNullList_<any>, i: number): void;
        abstract matches(arg0: Internal.IPartBuilderContainer_, arg1: Internal.Level_): boolean;
        getMod(): string;
        getIngredients(): Internal.NonNullList<Internal.Ingredient>;
        abstract getPattern(): slimeknights.tconstruct.library.recipe.partbuilder.Pattern;
        isSpecial(): boolean;
        hasOutput(match: Internal.ReplacementMatch_): boolean;
        abstract getResultItem(arg0: Internal.RegistryAccess_): Internal.ItemStack;
        assemble(inv: Internal.IPartBuilderContainer_, registryAccess: Internal.RegistryAccess_): Internal.ItemStack;
        /**
         * @deprecated
        */
        canCraftInDimensions(width: number, height: number): boolean;
        showNotification(): boolean;
        replaceInput(match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        assemble(inv: Internal.IPartBuilderContainer_, pattern: slimeknights.tconstruct.library.recipe.partbuilder.Pattern_, registryAccess: Internal.RegistryAccess_): Internal.ItemStack;
        getType(): ResourceLocation;
        setGroup(group: string): void;
        getRemainingItems($$0: Internal.IPartBuilderContainer_): Internal.NonNullList<Internal.ItemStack>;
        getOrCreateId(): ResourceLocation;
        hasInput(match: Internal.ReplacementMatch_): boolean;
        isIncomplete(): boolean;
        getTitle(): net.minecraft.network.chat.Component;
        getText(inv: Internal.IPartBuilderContainer_): Internal.List<net.minecraft.network.chat.Component>;
        replaceOutput(match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        get group(): string
        get toastSymbol(): Internal.ItemStack
        get schema(): Internal.RecipeSchema
        get serializer(): Internal.RecipeSerializer<any>
        get id(): ResourceLocation
        get cost(): number
        get mod(): string
        get ingredients(): Internal.NonNullList<Internal.Ingredient>
        get pattern(): slimeknights.tconstruct.library.recipe.partbuilder.Pattern
        get special(): boolean
        get type(): ResourceLocation
        set group(group: string)
        get orCreateId(): ResourceLocation
        get incomplete(): boolean
        get title(): net.minecraft.network.chat.Component
    }
    type IPartBuilderRecipe_ = IPartBuilderRecipe;
    class BaseCoralFanBlock extends Internal.BaseCoralPlantTypeBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type BaseCoralFanBlock_ = BaseCoralFanBlock;
    class ConditionalRecipe$Serializer <T extends Internal.Recipe<any>> implements Internal.RecipeSerializer<T> {
        constructor()
        static register<S extends Internal.RecipeSerializer<T>, T extends Internal.Recipe<any>>($$0: string, $$1: S): S;
        fromJson(recipeId: ResourceLocation_, json: Internal.JsonObject_): T;
        fromNetwork(recipeId: ResourceLocation_, buffer: Internal.FriendlyByteBuf_): T;
        static processConditions(conditions: Internal.JsonArray_): boolean;
        toNetwork(buffer: Internal.FriendlyByteBuf_, recipe: T): void;
    }
    type ConditionalRecipe$Serializer_<T extends Internal.Recipe<any>> = ConditionalRecipe$Serializer<T>;
    interface BiomeManager$NoiseBiomeSource {
        abstract getNoiseBiome(arg0: number, arg1: number, arg2: number): Internal.Holder<Internal.Biome>;
        (arg0: number, arg1: number, arg2: number): Internal.Holder_<Internal.Biome>;
    }
    type BiomeManager$NoiseBiomeSource_ = BiomeManager$NoiseBiomeSource;
    interface VillagerEntityAccessor {
        fabric_setGatherableItems(items: Internal.Set_<Internal.Item>): void;
        fabric_setItemFoodValues(items: Internal.Map_<Internal.Item, number>): void;
        fabric_getGatherableItems(): Internal.Set<Internal.Item>;
    }
    type VillagerEntityAccessor_ = VillagerEntityAccessor;
    interface ISyncMount {
    }
    type ISyncMount_ = ISyncMount;
    class CustomValue$CvType extends Internal.Enum<Internal.CustomValue$CvType> {
        static values(): Internal.CustomValue$CvType[];
        static valueOf(arg0: string): Internal.CustomValue$CvType;
        static readonly NUMBER: Internal.CustomValue$CvType;
        static readonly OBJECT: Internal.CustomValue$CvType;
        static readonly ARRAY: Internal.CustomValue$CvType;
        static readonly NULL: Internal.CustomValue$CvType;
        static readonly STRING: Internal.CustomValue$CvType;
        static readonly BOOLEAN: Internal.CustomValue$CvType;
    }
    type CustomValue$CvType_ = CustomValue$CvType | "null" | "string" | "boolean" | "object" | "number" | "array";
    class Scoreboard implements Internal.ComponentProvider {
        constructor()
        getPlayersTeam($$0: string): Internal.PlayerTeam;
        getPlayerScores($$0: Internal.Objective_): Internal.Collection<Internal.Score>;
        getDisplayObjective($$0: number): Internal.Objective;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        hasPlayerScore($$0: string, $$1: Internal.Objective_): boolean;
        onTeamAdded($$0: Internal.PlayerTeam_): void;
        toComponentPacket<C extends Internal.AutoSyncedComponent>(key: Internal.ComponentKey_<C>, writer: Internal.ComponentPacketWriter_, recipient: Internal.ServerPlayer_): Internal.ClientboundCustomPayloadPacket;
        removePlayerFromTeam($$0: string, $$1: Internal.PlayerTeam_): void;
        removePlayerTeam($$0: Internal.PlayerTeam_): void;
        static getDisplaySlotName($$0: number): string;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        static getDisplaySlotByName($$0: string): number;
        onObjectiveChanged($$0: Internal.Objective_): void;
        onObjectiveAdded($$0: Internal.Objective_): void;
        onScoreChanged($$0: Internal.Score_): void;
        onPlayerRemoved($$0: string): void;
        removeObjective($$0: Internal.Objective_): void;
        addObjective($$0: string, $$1: Internal.ObjectiveCriteria_, $$2: net.minecraft.network.chat.Component_, $$3: Internal.ObjectiveCriteria$RenderType_): Internal.Objective;
        getPlayerScores($$0: string): Internal.Map<Internal.Objective, Internal.Score>;
        forAllObjectives($$0: Internal.ObjectiveCriteria_, $$1: string, $$2: Internal.Consumer_<Internal.Score>): void;
        onTeamRemoved($$0: Internal.PlayerTeam_): void;
        removePlayerFromTeam($$0: string): boolean;
        getOrCreateObjective($$0: string): Internal.Objective;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        addPlayerTeam($$0: string): Internal.PlayerTeam;
        onTeamChanged($$0: Internal.PlayerTeam_): void;
        getPlayerTeam($$0: string): Internal.PlayerTeam;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        entityRemoved($$0: Internal.Entity_): void;
        resetPlayerScore($$0: string, $$1: Internal.Objective_): void;
        getObjectives(): Internal.Collection<Internal.Objective>;
        getRecipientsForComponentSync(): Internal.Iterable<Internal.ServerPlayer>;
        onPlayerScoreRemoved($$0: string, $$1: Internal.Objective_): void;
        addPlayerToTeam($$0: string, $$1: Internal.PlayerTeam_): boolean;
        hasObjective($$0: string): boolean;
        getOrCreatePlayerScore($$0: string, $$1: Internal.Objective_): Internal.Score;
        getPlayerTeams(): Internal.Collection<Internal.PlayerTeam>;
        getObjectiveNames(): Internal.Collection<string>;
        getTrackedPlayers(): Internal.Collection<string>;
        getTeamNames(): Internal.Collection<string>;
        onObjectiveRemoved($$0: Internal.Objective_): void;
        static getDisplaySlotNames(): string[];
        getComponentContainer(): Internal.ComponentContainer;
        getObjective($$0: string): Internal.Objective;
        setDisplayObjective($$0: number, $$1: Internal.Objective_): void;
        get objectives(): Internal.Collection<Internal.Objective>
        get recipientsForComponentSync(): Internal.Iterable<Internal.ServerPlayer>
        get playerTeams(): Internal.Collection<Internal.PlayerTeam>
        get objectiveNames(): Internal.Collection<string>
        get trackedPlayers(): Internal.Collection<string>
        get teamNames(): Internal.Collection<string>
        get displaySlotNames(): string[]
        get componentContainer(): Internal.ComponentContainer
        static readonly DISPLAY_SLOTS: 19;
        static readonly DISPLAY_SLOT_TEAMS_SIDEBAR_END: 18;
        static readonly DISPLAY_SLOT_SIDEBAR: 1;
        static readonly DISPLAY_SLOT_TEAMS_SIDEBAR_START: 3;
        static readonly DISPLAY_SLOT_BELOW_NAME: 2;
        static readonly DISPLAY_SLOT_LIST: 0;
    }
    type Scoreboard_ = Scoreboard;
    class NamedPackage {
    }
    type NamedPackage_ = NamedPackage;
    class WaterlilyBlockBOP extends Internal.BushBlock {
        constructor(p_58162_: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getPlantType(world: Internal.BlockGetter_, pos: BlockPos_): Internal.PlantType;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type WaterlilyBlockBOP_ = WaterlilyBlockBOP;
    interface MovementTrackerCache {
        abstract deduplicate<S extends Internal.SectionedEntityMovementTracker<any, any>>(arg0: S): S;
        abstract remove(arg0: Internal.SectionedEntityMovementTracker_<any, any>): void;
    }
    type MovementTrackerCache_ = MovementTrackerCache;
    interface TagEntry$Lookup <T> {
        abstract tag(arg0: ResourceLocation_): Internal.Collection<T>;
        abstract element(arg0: ResourceLocation_): T;
    }
    type TagEntry$Lookup_<T> = TagEntry$Lookup<T>;
    abstract class GrowingPlantBlock extends Internal.Block {
        getStateForPlacement($$0: Internal.LevelAccessor_): Internal.BlockState;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type GrowingPlantBlock_ = GrowingPlantBlock;
    interface ModifierRepairRecipeSerializer$IModifierRepairRecipe {
        abstract getModifier(): Internal.ModifierId;
        abstract getIngredient(): Internal.Ingredient;
        abstract getRepairAmount(): number;
        get modifier(): Internal.ModifierId
        get ingredient(): Internal.Ingredient
        get repairAmount(): number
    }
    type ModifierRepairRecipeSerializer$IModifierRepairRecipe_ = ModifierRepairRecipeSerializer$IModifierRepairRecipe;
    class TransportedItemStack implements Internal.Comparable<Internal.TransportedItemStack> {
        constructor(stack: Internal.ItemStack_)
        compareTo(o: Internal.TransportedItemStack_): number;
        static read(nbt: Internal.CompoundTag_): Internal.TransportedItemStack;
        copy(): this;
        fullCopy(): this;
        clearFanProcessingData(): void;
        getTargetSideOffset(): number;
        getSimilar(): this;
        compareTo(arg0: any): number;
        serializeNBT(): Internal.CompoundTag;
        get targetSideOffset(): number
        get similar(): Internal.TransportedItemStack
        stack: Internal.ItemStack;
        prevBeltPosition: number;
        static readonly EMPTY: Internal.TransportedItemStack;
        beltPosition: number;
        insertedAt: number;
        processedBy: Internal.FanProcessingType;
        lockedExternally: boolean;
        prevSideOffset: number;
        locked: boolean;
        processingTime: number;
        sideOffset: number;
        insertedFrom: Internal.Direction;
        angle: number;
    }
    type TransportedItemStack_ = TransportedItemStack;
    abstract class DirectionalAxisKineticBlock extends Internal.DirectionalKineticBlock implements Internal.TransformableBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        hideStressImpact(): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        transform(state: Internal.BlockState_, transform: Internal.StructureTransform_): Internal.BlockState;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        showCapacityWithAnnotation(): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        getMinimumRequiredSpeedLevel(): Internal.IRotate$SpeedLevel;
        emi(amount: number): Internal.EmiStack;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        get minimumRequiredSpeedLevel(): Internal.IRotate$SpeedLevel
        static readonly AXIS_ALONG_FIRST_COORDINATE: Internal.BooleanProperty;
    }
    type DirectionalAxisKineticBlock_ = DirectionalAxisKineticBlock;
    interface IVariableProvider {
        abstract get(arg0: string): Internal.IVariable;
        abstract has(arg0: string): boolean;
    }
    type IVariableProvider_ = IVariableProvider;
    interface CustomIngredientKJS {
        kjs$canBeUsedForMatching(): boolean;
    }
    type CustomIngredientKJS_ = CustomIngredientKJS;
    abstract class Format implements Internal.Cloneable, Internal.Serializable {
        clone(): any;
        abstract format(arg0: any, arg1: Internal.StringBuffer_, arg2: Internal.FieldPosition_): Internal.StringBuffer;
        formatToCharacterIterator(arg0: any): Internal.AttributedCharacterIterator;
        parseObject(arg0: string): any;
        abstract parseObject(arg0: string, arg1: Internal.ParsePosition_): any;
        format(arg0: any): string;
    }
    type Format_ = Format;
    class TrapDoorBlock extends Internal.HorizontalDirectionalBlock implements Internal.SimpleWaterloggedBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_, $$1: Internal.BlockSetType_)
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly HALF: Internal.EnumProperty<Internal.Half>;
        static readonly WATERLOGGED: Internal.BooleanProperty;
        static readonly OPEN: Internal.BooleanProperty;
        static readonly POWERED: Internal.BooleanProperty;
    }
    type TrapDoorBlock_ = TrapDoorBlock;
    class TableClothBlock extends Internal.Block implements Internal.IHaveBigOutline, com.simibubi.create.content.equipment.wrench.IWrenchable, Internal.IBE<Internal.TableClothBlockEntity> {
        constructor(pProperties: Internal.BlockBehaviour$Properties_, type: string)
        constructor(pProperties: Internal.BlockBehaviour$Properties_, colour: Internal.DyeColor_)
        newBlockEntity(pos: BlockPos_, state: Internal.BlockState_): Internal.BlockEntity;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.TableClothBlockEntity>;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockEntityType(): Internal.BlockEntityType<Internal.TableClothBlockEntity>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.TableClothBlockEntity>): void;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.TableClothBlockEntity;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        getColor(): Internal.DyeColor;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        getBlockEntityClass(): typeof Internal.TableClothBlockEntity;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.TableClothBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        emi(): Internal.EmiStack;
        get blockEntityType(): Internal.BlockEntityType<Internal.TableClothBlockEntity>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        get color(): Internal.DyeColor
        set destroySpeed(v: number)
        get blockEntityClass(): typeof Internal.TableClothBlockEntity
        static readonly HAS_BE: Internal.BooleanProperty;
    }
    type TableClothBlock_ = TableClothBlock;
    class AbstractArrow$Pickup extends Internal.Enum<Internal.AbstractArrow$Pickup> {
        static values(): Internal.AbstractArrow$Pickup[];
        static byOrdinal($$0: number): Internal.AbstractArrow$Pickup;
        static valueOf($$0: string): Internal.AbstractArrow$Pickup;
        static readonly DISALLOWED: Internal.AbstractArrow$Pickup;
        static readonly ALLOWED: Internal.AbstractArrow$Pickup;
        static readonly CREATIVE_ONLY: Internal.AbstractArrow$Pickup;
    }
    type AbstractArrow$Pickup_ = "allowed" | "disallowed" | "creative_only" | AbstractArrow$Pickup;
    class VertexFormatElement {
        constructor($$0: number, $$1: Internal.VertexFormatElement$Type_, $$2: Internal.VertexFormatElement$Usage_, $$3: number)
        getType(): Internal.VertexFormatElement$Type;
        getByteSize(): number;
        getCount(): number;
        getUsage(): Internal.VertexFormatElement$Usage;
        getIndex(): number;
        setupBufferState($$0: number, $$1: number, $$2: number): void;
        clearBufferState($$0: number): void;
        isPosition(): boolean;
        get type(): Internal.VertexFormatElement$Type
        get byteSize(): number
        get count(): number
        get usage(): Internal.VertexFormatElement$Usage
        get index(): number
        get position(): boolean
        readonly count: number;
    }
    type VertexFormatElement_ = VertexFormatElement;
    class SnifferEggBlock extends Internal.Block {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        getHatchLevel($$0: Internal.BlockState_): number;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        static hatchBoost($$0: Internal.BlockGetter_, $$1: BlockPos_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly MAX_HATCH_LEVEL: 2;
        static readonly HATCH: Internal.IntegerProperty;
    }
    type SnifferEggBlock_ = SnifferEggBlock;
    class CanyonWorldCarver extends Internal.WorldCarver<Internal.CanyonCarverConfiguration> {
        constructor($$0: Internal.Codec_<Internal.CanyonCarverConfiguration>)
        isStartChunk($$0: Internal.CanyonCarverConfiguration_, $$1: Internal.RandomSource_): boolean;
        carve($$0: Internal.CarvingContext_, $$1: Internal.CanyonCarverConfiguration_, $$2: Internal.ChunkAccess_, $$3: Internal.Function_<BlockPos, Internal.Holder<Internal.Biome>>, $$4: Internal.RandomSource_, $$5: Internal.Aquifer_, $$6: Internal.ChunkPos_, $$7: Internal.CarvingMask_): boolean;
    }
    type CanyonWorldCarver_ = CanyonWorldCarver;
    class RenderShape extends Internal.Enum<Internal.RenderShape> {
        static values(): Internal.RenderShape[];
        static valueOf($$0: string): Internal.RenderShape;
        static readonly ENTITYBLOCK_ANIMATED: Internal.RenderShape;
        static readonly MODEL: Internal.RenderShape;
        static readonly INVISIBLE: Internal.RenderShape;
    }
    type RenderShape_ = RenderShape | "model" | "invisible" | "entityblock_animated";
    class Proxy {
        constructor(arg0: Internal.Proxy$Type_, arg1: Internal.SocketAddress_)
        address(): Internal.SocketAddress;
        type(): Internal.Proxy$Type;
        static readonly NO_PROXY: Internal.Proxy;
    }
    type Proxy_ = Proxy;
    class BrimstoneClusterBlock extends Internal.DoublePlantBlockBOP {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getPlantType(world: Internal.BlockGetter_, pos: BlockPos_): Internal.PlantType;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type BrimstoneClusterBlock_ = BrimstoneClusterBlock;
    interface INBTSerializable <T extends Internal.Tag> {
        serializeNBT(): T;
        deserializeNBT(nbt: T): void;
    }
    type INBTSerializable_<T extends Internal.Tag> = INBTSerializable<T>;
    class BlockMediafiedStorage$Companion {
        constructor($constructor_marker: any_)
        getCLOSED_SHAPE(): Internal.VoxelShape;
        static access$tick($this: Internal.BlockMediafiedStorage$Companion_, level: Internal.Level_, blockPos: BlockPos_, blockState: Internal.BlockState_, t: Internal.BlockEntity_): void;
        getOPEN_SHAPE(): Internal.VoxelShape;
        get CLOSED_SHAPE(): Internal.VoxelShape
        get OPEN_SHAPE(): Internal.VoxelShape
    }
    type BlockMediafiedStorage$Companion_ = BlockMediafiedStorage$Companion;
    class DragSourceDropEvent extends Internal.DragSourceEvent {
        constructor(arg0: Internal.DragSourceContext_)
        constructor(arg0: Internal.DragSourceContext_, arg1: number, arg2: boolean, arg3: number, arg4: number)
        constructor(arg0: Internal.DragSourceContext_, arg1: number, arg2: boolean)
        getDropAction(): number;
        getDropSuccess(): boolean;
        get dropAction(): number
        get dropSuccess(): boolean
    }
    type DragSourceDropEvent_ = DragSourceDropEvent;
    class RenderType$CompositeState$CompositeStateBuilder {
        setLightmapState($$0: Internal.RenderStateShard$LightmapStateShard_): this;
        setLineState($$0: Internal.RenderStateShard$LineStateShard_): this;
        setCullState($$0: Internal.RenderStateShard$CullStateShard_): this;
        setTransparencyState($$0: Internal.RenderStateShard$TransparencyStateShard_): this;
        setTextureState($$0: Internal.RenderStateShard$EmptyTextureStateShard_): this;
        setTexturingState($$0: Internal.RenderStateShard$TexturingStateShard_): this;
        setColorLogicState($$0: Internal.RenderStateShard$ColorLogicStateShard_): this;
        setShaderState($$0: Internal.RenderStateShard$ShaderStateShard_): this;
        setDepthTestState($$0: Internal.RenderStateShard$DepthTestStateShard_): this;
        setOverlayState($$0: Internal.RenderStateShard$OverlayStateShard_): this;
        setWriteMaskState($$0: Internal.RenderStateShard$WriteMaskStateShard_): this;
        setOutputState($$0: Internal.RenderStateShard$OutputStateShard_): this;
        setLayeringState($$0: Internal.RenderStateShard$LayeringStateShard_): this;
        createCompositeState($$0: boolean): Internal.RenderType$CompositeState;
        createCompositeState($$0: Internal.RenderType$OutlineProperty_): Internal.RenderType$CompositeState;
        set lightmapState($$0: Internal.RenderStateShard$LightmapStateShard_)
        set lineState($$0: Internal.RenderStateShard$LineStateShard_)
        set cullState($$0: Internal.RenderStateShard$CullStateShard_)
        set transparencyState($$0: Internal.RenderStateShard$TransparencyStateShard_)
        set textureState($$0: Internal.RenderStateShard$EmptyTextureStateShard_)
        set texturingState($$0: Internal.RenderStateShard$TexturingStateShard_)
        set colorLogicState($$0: Internal.RenderStateShard$ColorLogicStateShard_)
        set shaderState($$0: Internal.RenderStateShard$ShaderStateShard_)
        set depthTestState($$0: Internal.RenderStateShard$DepthTestStateShard_)
        set overlayState($$0: Internal.RenderStateShard$OverlayStateShard_)
        set writeMaskState($$0: Internal.RenderStateShard$WriteMaskStateShard_)
        set outputState($$0: Internal.RenderStateShard$OutputStateShard_)
        set layeringState($$0: Internal.RenderStateShard$LayeringStateShard_)
    }
    type RenderType$CompositeState$CompositeStateBuilder_ = RenderType$CompositeState$CompositeStateBuilder;
    class ItemBlindfold extends Internal.ArmorItem implements Internal.IArmorFinder, Internal.IArmorTextureProvider {
        constructor()
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        static get($$0: Internal.ItemStack_): Internal.Equipable;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        kjs$getMutableAttributeMap(): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        isEquipped(player: Internal.LivingEntity_, stack: Internal.ItemStack_): boolean;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        getArmorTexture(stack: Internal.ItemStack_, entity: Internal.Entity_, slot: Internal.EquipmentSlot_, type: string): ResourceLocation;
        swapWithEquipmentSlot($$0: Internal.Item_, $$1: Internal.Level_, $$2: Internal.Player_, $$3: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        isEquipped(player: Internal.LivingEntity_, item: Internal.Item_): boolean;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type ItemBlindfold_ = ItemBlindfold;
    class ClipboardBlockItem extends Internal.BlockItem implements Internal.ItemCopyingRecipe$SupportsItemCopying {
        constructor(pBlock: Internal.Block_, pProperties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        canCopyFromItem(item: Internal.ItemStack_): boolean;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        canCopyToItem(item: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        registerModelOverrides(): void;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        createCopy(original: Internal.ItemStack_, count: number): Internal.ItemStack;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeFromBlockToItemMap(blockToItemMap: Internal.Map_<Internal.Block, Internal.Item>, itemIn: Internal.Item_): void;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type ClipboardBlockItem_ = ClipboardBlockItem;
    interface IEnergyConnector {
    }
    type IEnergyConnector_ = IEnergyConnector;
    interface ServicesKeyInfo {
        abstract keyBitCount(): number;
        abstract signature(): Internal.Signature;
        abstract validateProperty(arg0: com.mojang.authlib.properties.Property_): boolean;
        signatureBitCount(): number;
    }
    type ServicesKeyInfo_ = ServicesKeyInfo;
    class CommandComputerItem extends Internal.ComputerItem {
        constructor(block: Internal.ComputerBlock_<any>, settings: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        getComputerID(stack: Internal.ItemStack_): number;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeFromBlockToItemMap(blockToItemMap: Internal.Map_<Internal.Block, Internal.Item>, itemIn: Internal.Item_): void;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type CommandComputerItem_ = CommandComputerItem;
    interface StructureProcessorType <P extends Internal.StructureProcessor> {
        abstract codec(): Internal.Codec<P>;
        register<P extends Internal.StructureProcessor>($$0: string, $$1: Internal.Codec_<P>): this;
        (): Internal.Codec_<P>;
        readonly LIST_CODEC: Internal.Codec<Internal.Holder<Internal.StructureProcessorList>>;
        readonly SINGLE_CODEC: Internal.Codec<Internal.StructureProcessor>;
        readonly LIST_OBJECT_CODEC: Internal.Codec<Internal.StructureProcessorList>;
        readonly BLACKSTONE_REPLACE: Internal.StructureProcessorType<Internal.BlackstoneReplaceProcessor>;
        readonly LAVA_SUBMERGED_BLOCK: Internal.StructureProcessorType<Internal.LavaSubmergedBlockProcessor>;
        readonly PROTECTED_BLOCKS: Internal.StructureProcessorType<Internal.ProtectedBlockProcessor>;
        readonly BLOCK_ROT: Internal.StructureProcessorType<Internal.BlockRotProcessor>;
        readonly CAPPED: Internal.StructureProcessorType<Internal.CappedProcessor>;
        readonly DIRECT_CODEC: Internal.Codec<Internal.StructureProcessorList>;
        readonly BLOCK_IGNORE: Internal.StructureProcessorType<Internal.BlockIgnoreProcessor>;
        readonly GRAVITY: Internal.StructureProcessorType<Internal.GravityProcessor>;
        readonly RULE: Internal.StructureProcessorType<Internal.RuleProcessor>;
        readonly NOP: Internal.StructureProcessorType<Internal.NopProcessor>;
        readonly JIGSAW_REPLACEMENT: Internal.StructureProcessorType<Internal.JigsawReplacementProcessor>;
        readonly BLOCK_AGE: Internal.StructureProcessorType<Internal.BlockAgeProcessor>;
    }
    type StructureProcessorType_<P extends Internal.StructureProcessor> = Special.StructureProcessor | StructureProcessorType<P>;
    class ChestMenu extends Internal.AbstractContainerMenu {
        constructor($$0: Internal.MenuType_<any>, $$1: number, $$2: Internal.Inventory_, $$3: net.minecraft.world.Container_, $$4: number)
        static twoRows($$0: number, $$1: Internal.Inventory_): Internal.ChestMenu;
        static oneRow($$0: number, $$1: Internal.Inventory_): Internal.ChestMenu;
        static threeRows($$0: number, $$1: Internal.Inventory_, $$2: net.minecraft.world.Container_): Internal.ChestMenu;
        getRowCount(): number;
        static sixRows($$0: number, $$1: Internal.Inventory_, $$2: net.minecraft.world.Container_): Internal.ChestMenu;
        static threeRows($$0: number, $$1: Internal.Inventory_): Internal.ChestMenu;
        getContainer(): net.minecraft.world.Container;
        static sixRows($$0: number, $$1: Internal.Inventory_): Internal.ChestMenu;
        static fiveRows($$0: number, $$1: Internal.Inventory_): Internal.ChestMenu;
        static fourRows($$0: number, $$1: Internal.Inventory_): Internal.ChestMenu;
        get rowCount(): number
        get container(): net.minecraft.world.Container
    }
    type ChestMenu_ = ChestMenu;
    interface IAlloyTank extends Internal.IEmptyContainer {
        stopOpen($$0: Internal.Player_): void;
        tryClear($$0: any): void;
        setStackInSlot(slot: number, stack: Internal.ItemStack_): void;
        clear(ingredient: Internal.Ingredient_): void;
        find(): number;
        hasAnyOf($$0: Internal.Set_<Internal.Item>): boolean;
        /**
         * @deprecated
        */
        removeItem(index: number, count: number): Internal.ItemStack;
        getSlots(): number;
        /**
         * @deprecated
        */
        setChanged(): void;
        /**
         * @deprecated
        */
        getContainerSize(): number;
        abstract getFluidInTank(arg0: number): Internal.FluidStack;
        /**
         * @deprecated
        */
        setItem(index: number, stack: Internal.ItemStack_): void;
        hasAnyMatching($$0: Internal.Predicate_<Internal.ItemStack>): boolean;
        kjs$self(): net.minecraft.world.Container;
        getWidth(): number;
        getSlotLimit(slot: number): number;
        getMaxStackSize(): number;
        /**
         * @deprecated
        */
        removeItemNoUpdate(index: number): Internal.ItemStack;
        stillValidBlockEntity($$0: Internal.BlockEntity_, $$1: Internal.Player_): boolean;
        abstract getTanks(): number;
        /**
         * @deprecated
        */
        getItem(index: number): Internal.ItemStack;
        abstract getTemperature(): number;
        isItemValid(slot: number, stack: Internal.ItemStack_): boolean;
        count(ingredient: Internal.Ingredient_): number;
        count(): number;
        setTransferCooldown(currentTime: number): void;
        countItem($$0: Internal.Item_): number;
        /**
         * @deprecated
        */
        isEmpty(): boolean;
        startOpen($$0: Internal.Player_): void;
        canPlaceItem($$0: number, $$1: Internal.ItemStack_): boolean;
        extractItem(slot: number, amount: number, simulate: boolean): Internal.ItemStack;
        getBlock(level: Internal.Level_): Internal.BlockContainerJS;
        stillValidBlockEntity($$0: Internal.BlockEntity_, $$1: Internal.Player_, $$2: number): boolean;
        canReceiveTransferCooldown(): boolean;
        getStackInSlot(slot: number): Internal.ItemStack;
        getHeight(): number;
        countNonEmpty(): number;
        asContainer(): net.minecraft.world.Container;
        getAllItems(): Internal.List<Internal.ItemStack>;
        canTakeItem($$0: net.minecraft.world.Container_, $$1: number, $$2: Internal.ItemStack_): boolean;
        insertItem(stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        /**
         * @deprecated
        */
        stillValid(player: Internal.Player_): boolean;
        insertItem(slot: number, stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        isMutable(): boolean;
        clear(): void;
        find(ingredient: Internal.Ingredient_): number;
        /**
         * @deprecated
        */
        clearContent(): void;
        countNonEmpty(ingredient: Internal.Ingredient_): number;
        abstract canFit(arg0: Internal.FluidStack_, arg1: number): boolean;
        get slots(): number
        /**
         * @deprecated
        */
        get containerSize(): number
        get width(): number
        get maxStackSize(): number
        get tanks(): number
        get temperature(): number
        set transferCooldown(currentTime: number)
        /**
         * @deprecated
        */
        get empty(): boolean
        get height(): number
        get allItems(): Internal.List<Internal.ItemStack>
        get mutable(): boolean
    }
    type IAlloyTank_ = IAlloyTank;
    class DocumentClass extends Internal.AbstractDocument<Internal.DocumentClass> {
        constructor()
        merge(arg0: Internal.AbstractDocumentBase_<any>): Internal.AbstractDocumentBase<any>;
        copy(): Internal.AbstractDocumentBase<any>;
        isAbstract(): boolean;
        applyProperties(): Internal.AbstractDocumentBase<any>;
        getConstructors(): Internal.Set<Internal.DocumentConstructor>;
        isInterface(): boolean;
        setAbstract(anAbstract: boolean): void;
        setInterface(anInterface: boolean): void;
        merge(other: Internal.DocumentClass_): this;
        getInterfaces(): Internal.Set<Internal.PropertyType<any>>;
        getParent(): Internal.PropertyType<any>;
        getFields(): Internal.Set<Internal.DocumentField>;
        setName(name: string): void;
        getName(): string;
        getMethods(): Internal.Set<Internal.DocumentMethod>;
        setParent(parent: Internal.PropertyType_<any>): void;
        static fromJava(info: Internal.ClassInfo_): Internal.DocumentClass;
        getGenerics(): Internal.List<Internal.PropertyType<any>>;
        get "abstract"(): boolean
        get constructors(): Internal.Set<Internal.DocumentConstructor>
        get "interface"(): boolean
        set "abstract"(anAbstract: boolean)
        set "interface"(anInterface: boolean)
        get interfaces(): Internal.Set<Internal.PropertyType<any>>
        get parent(): Internal.PropertyType<any>
        get fields(): Internal.Set<Internal.DocumentField>
        set name(name: string)
        get name(): string
        get methods(): Internal.Set<Internal.DocumentMethod>
        set parent(parent: Internal.PropertyType_<any>)
        get generics(): Internal.List<Internal.PropertyType<any>>
        methods: Internal.Set<Internal.DocumentMethod>;
        fields: Internal.Set<Internal.DocumentField>;
        interfaces: Internal.Set<Internal.PropertyType<any>>;
        constructors: Internal.Set<Internal.DocumentConstructor>;
    }
    type DocumentClass_ = DocumentClass;
    class GeodeCrackSettings {
        constructor($$0: number, $$1: number, $$2: number)
        static readonly CODEC: Internal.Codec<Internal.GeodeCrackSettings>;
        readonly generateCrackChance: number;
        readonly baseCrackSize: number;
        readonly crackPointOffset: number;
    }
    type GeodeCrackSettings_ = GeodeCrackSettings;
    class LayerPattern$Layer {
        constructor(targets: Internal.List_<Internal.List<Internal.OreConfiguration$TargetBlockState>>, minSize: number, maxSize: number, weight: number)
        rollBlock(random: Internal.RandomSource_): Internal.List<Internal.OreConfiguration$TargetBlockState>;
        static readonly CODEC: Internal.Codec<Internal.LayerPattern$Layer>;
        readonly minSize: number;
        readonly targets: Internal.List<Internal.List<Internal.OreConfiguration$TargetBlockState>>;
        readonly maxSize: number;
        readonly weight: number;
    }
    type LayerPattern$Layer_ = LayerPattern$Layer;
    class OrganicCompostBlock extends Internal.Block {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        getMaxCompostingStage(): number;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get maxCompostingStage(): number
        set lightEmission(v: number)
        get mod(): string
        static COMPOSTING: Internal.IntegerProperty;
    }
    type OrganicCompostBlock_ = OrganicCompostBlock;
    interface PlatformMenuProvider extends Internal.ExtendedScreenHandlerFactory, Internal.MenuProvider {
        abstract getDisplayName(): net.minecraft.network.chat.Component;
        shouldCloseCurrentScreen(): boolean;
        writeScreenOpeningData(player: Internal.ServerPlayer_, buf: Internal.FriendlyByteBuf_): void;
        abstract createMenu(arg0: number, arg1: Internal.Inventory_, arg2: Internal.Player_): Internal.AbstractContainerMenu;
        get displayName(): net.minecraft.network.chat.Component
    }
    type PlatformMenuProvider_ = PlatformMenuProvider;
    class SurfaceSystem {
        constructor($$0: Internal.RandomState_, $$1: Internal.BlockState_, $$2: number, $$3: Internal.PositionalRandomFactory_)
        buildSurface($$0: Internal.RandomState_, $$1: Internal.BiomeManager_, $$2: Internal.Registry_<Internal.Biome>, $$3: boolean, $$4: Internal.WorldGenerationContext_, $$5: Internal.ChunkAccess_, $$6: Internal.NoiseChunk_, $$7: Internal.SurfaceRules$RuleSource_): void;
        /**
         * @deprecated
        */
        topMaterial($$0: Internal.SurfaceRules$RuleSource_, $$1: Internal.CarvingContext_, $$2: Internal.Function_<BlockPos, Internal.Holder<Internal.Biome>>, $$3: Internal.ChunkAccess_, $$4: Internal.NoiseChunk_, $$5: BlockPos_, $$6: boolean): Internal.Optional<Internal.BlockState>;
    }
    type SurfaceSystem_ = SurfaceSystem;
    class BlockMatchTest extends Internal.RuleTest implements Internal.BlockMatchTestAccessor {
        constructor($$0: Internal.Block_)
        getBlock(): Internal.Block;
        get block(): Internal.Block
        static readonly CODEC: Internal.Codec<Internal.BlockMatchTest>;
    }
    type BlockMatchTest_ = BlockMatchTest;
    class ShapedRecipeBuilder extends Internal.CraftingRecipeBuilder implements Internal.RecipeBuilder {
        constructor($$0: Internal.RecipeCategory_, $$1: Internal.ItemLike_, $$2: number)
        save($$0: Internal.Consumer_<Internal.FinishedRecipe>, $$1: string): void;
        static shaped($$0: Internal.RecipeCategory_, $$1: Internal.ItemLike_): Internal.ShapedRecipeBuilder;
        define($$0: string, $$1: Internal.ItemLike_): this;
        static shaped($$0: Internal.RecipeCategory_, $$1: Internal.ItemLike_, $$2: number): Internal.ShapedRecipeBuilder;
        static getDefaultRecipeId($$0: Internal.ItemLike_): ResourceLocation;
        unlockedBy($$0: string, $$1: Internal.CriterionTriggerInstance_): this;
        getResult(): Internal.Item;
        group(arg0: string): Internal.RecipeBuilder;
        define($$0: string, $$1: Internal.TagKey_<Internal.Item>): this;
        group($$0: string): this;
        save($$0: Internal.Consumer_<Internal.FinishedRecipe>): void;
        define($$0: string, $$1: Internal.Ingredient_): this;
        pattern($$0: string): this;
        showNotification($$0: boolean): this;
        save($$0: Internal.Consumer_<Internal.FinishedRecipe>, $$1: ResourceLocation_): void;
        unlockedBy(arg0: string, arg1: Internal.CriterionTriggerInstance_): Internal.RecipeBuilder;
        get result(): Internal.Item
    }
    type ShapedRecipeBuilder_ = ShapedRecipeBuilder;
    interface ISubMenu {
        abstract getLocator(): Internal.MenuLocator;
        abstract getHost(): Internal.ISubMenuHost;
        get locator(): Internal.MenuLocator
        get host(): Internal.ISubMenuHost
    }
    type ISubMenu_ = ISubMenu;
    class EnchantmentConvertingRecipe$Serializer extends Internal.LoggingRecipeSerializer<Internal.EnchantmentConvertingRecipe> {
        constructor()
        static register<S extends Internal.RecipeSerializer<T>, T extends Internal.Recipe<any>>($$0: string, $$1: S): S;
        fromJson(arg0: ResourceLocation_, arg1: Internal.JsonObject_): Internal.Recipe<any>;
        toNetworkSafe(buffer: Internal.FriendlyByteBuf_, recipe: Internal.EnchantmentConvertingRecipe_): void;
        fromNetworkSafe(arg0: ResourceLocation_, arg1: Internal.FriendlyByteBuf_): Internal.Recipe<any>;
        fromJson(id: ResourceLocation_, json: Internal.JsonObject_): Internal.EnchantmentConvertingRecipe;
        toNetworkSafe(arg0: Internal.FriendlyByteBuf_, arg1: Internal.Recipe_<any>): void;
    }
    type EnchantmentConvertingRecipe$Serializer_ = EnchantmentConvertingRecipe$Serializer;
    class TriggerImpetusEffect implements Internal.PrestidigitationEffect {
        constructor()
        effectEntity(env: Internal.CastingEnvironment_, entity: Internal.Entity_): void;
        effectBlock(env: Internal.CastingEnvironment_, position: BlockPos_): void;
    }
    type TriggerImpetusEffect_ = TriggerImpetusEffect;
    class ContinuationWhile implements Internal.ContinuationFrame {
        constructor(loop: Internal.SpellList_)
        getLoop(): Internal.SpellList;
        getType(): Internal.ContinuationFrame$Type<any>;
        static fromNBT(tag: Internal.CompoundTag_, world: Internal.ServerLevel_): Internal.ContinuationFrame;
        size(): number;
        serializeToNBT(): Internal.CompoundTag;
        static toNBT(frame: Internal.ContinuationFrame_): Internal.CompoundTag;
        evaluate(continuation: Internal.SpellContinuation_, level: Internal.ServerLevel_, harness: Internal.CastingVM_): Internal.CastResult;
        breakDownwards(stack: Internal.List_<Internal.Iota>): kotlin.Pair<boolean, Internal.List<Internal.Iota>>;
        get loop(): Internal.SpellList
        get type(): Internal.ContinuationFrame$Type<any>
    }
    type ContinuationWhile_ = ContinuationWhile;
    class BasketBlock extends Internal.BaseEntityBlock implements Internal.SimpleWaterloggedBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>(level: Internal.Level_, state: Internal.BlockState_, blockEntityType: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly ENABLED: Internal.BooleanProperty;
        static readonly WATERLOGGED: Internal.BooleanProperty;
        static readonly OUT_SHAPE: Internal.VoxelShapeSimpleCube;
        static readonly RENDER_SHAPE: Internal.VoxelShapeSimpleCube;
        static readonly COLLISION_SHAPE_FACING: {[key: Internal.Direction]: Internal.ArrayVoxelShape, [key: Internal.Direction]: Internal.ArrayVoxelShape, [key: Internal.Direction]: Internal.ArrayVoxelShape, [key: Internal.Direction]: Internal.ArrayVoxelShape, [key: Internal.Direction]: Internal.ArrayVoxelShape, [key: Internal.Direction]: Internal.ArrayVoxelShape};
        static readonly FACING: Internal.DirectionProperty;
    }
    type BasketBlock_ = BasketBlock;
    class MinMaxBounds$Ints extends Internal.MinMaxBounds<number> {
        matchesSqr($$0: number): boolean;
        static fromReader($$0: Internal.StringReader_, $$1: Internal.Function_<number, number>): Internal.MinMaxBounds$Ints;
        static atLeast($$0: number): Internal.MinMaxBounds$Ints;
        matches($$0: number): boolean;
        static exactly($$0: number): Internal.MinMaxBounds$Ints;
        static fromReader($$0: Internal.StringReader_): Internal.MinMaxBounds$Ints;
        static fromJson($$0: Internal.JsonElement_): Internal.MinMaxBounds$Ints;
        static atMost($$0: number): Internal.MinMaxBounds$Ints;
        static between($$0: number, $$1: number): Internal.MinMaxBounds$Ints;
        static readonly ANY: Internal.MinMaxBounds$Ints;
    }
    type MinMaxBounds$Ints_ = MinMaxBounds$Ints;
    class PackagePortItem extends Internal.BlockItem {
        constructor(pBlock: Internal.Block_, pProperties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeFromBlockToItemMap(blockToItemMap: Internal.Map_<Internal.Block, Internal.Item>, itemIn: Internal.Item_): void;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type PackagePortItem_ = PackagePortItem;
    class EnumProperty <T extends Internal.Enum<T> & Internal.StringRepresentable> extends Internal.Property<T> {
        static create<T extends Internal.Enum<T> & Internal.StringRepresentable>($$0: string, $$1: T): Internal.EnumProperty<T>;
        static create<T extends Internal.Enum<T> & Internal.StringRepresentable>($$0: string, $$1: T, $$2: Internal.Predicate_<T>): Internal.EnumProperty<T>;
        getPossibleValues(): Internal.Collection<T>;
        getName($$0: T): string;
        getValue($$0: string): Internal.Optional<T>;
        static create<T extends Internal.Enum<T> & Internal.StringRepresentable>($$0: string, $$1: T, ...$$2: T[]): Internal.EnumProperty<T>;
        static create<T extends Internal.Enum<T> & Internal.StringRepresentable>($$0: string, $$1: T, $$2: Internal.Collection_<T>): Internal.EnumProperty<T>;
        get possibleValues(): Internal.Collection<T>
    }
    type EnumProperty_<T extends Internal.Enum<T> & Internal.StringRepresentable> = EnumProperty<T>;
}
declare namespace net.irisshaders.batchedentityrendering.mixin {
    interface RenderTypeAccessor {
        abstract shouldSortOnUpload(): boolean;
        (): boolean;
    }
    type RenderTypeAccessor_ = RenderTypeAccessor;
}
declare namespace net.irisshaders.iris.mixin {
    interface GameRendererAccessor {
        abstract invokeMethod_3186(arg0: Internal.PoseStack_, arg1: number): void;
        abstract invokeMethod_3198(arg0: Internal.PoseStack_, arg1: number): void;
        abstract getField_4001(): boolean;
        abstract getField_3992(): boolean;
        abstract shouldRenderBlockOutlineA(): boolean;
        abstract invokeMethod_3196(arg0: Internal.Camera_, arg1: number, arg2: boolean): number;
        get field_4001(): boolean
        get field_3992(): boolean
    }
    type GameRendererAccessor_ = GameRendererAccessor;
}
declare namespace it.unimi.dsi.fastutil.doubles {
    interface DoubleConsumer extends Internal.DoubleConsumer, Internal.Consumer<number> {
        abstract accept(arg0: number): void;
        /**
         * @deprecated
        */
        accept(arg0: any): void;
        /**
         * @deprecated
        */
        andThen(arg0: Internal.Consumer_<number>): Internal.Consumer<number>;
        /**
         * @deprecated
        */
        accept(arg0: number): void;
        andThen(arg0: Internal.DoubleConsumer_): Internal.DoubleConsumer;
        andThen(arg0: it.unimi.dsi.fastutil.doubles.DoubleConsumer_): this;
        (arg0: number): void;
    }
    type DoubleConsumer_ = DoubleConsumer;
}
